/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Toolkit;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StyleContext
implements Serializable,
AbstractDocument.AttributeContext {
    private static final long serialVersionUID = 8042858831190784241L;
    public static final String DEFAULT_STYLE = "default";
    static Hashtable sharedAttributeSets;
    static Hashtable sharedFonts;
    static StyleContext defaultStyleContext;
    static final int compressionThreshold = 9;
    private static Hashtable writeAttributeKeys;
    private static Hashtable readAttributeKeys;
    private NamedStyle styles;
    private transient MutableAttributeSet search = new SimpleAttributeSet();
    private transient Map attributeSetPool = Collections.synchronizedMap(new WeakHashMap());

    static {
        try {
            Iterator i = StyleConstants.keys.iterator();
            while (i.hasNext()) {
                StyleContext.registerStaticAttributeKey(i.next());
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        sharedAttributeSets = new Hashtable();
        sharedFonts = new Hashtable();
    }

    public StyleContext() {
        this.styles = new NamedStyle(null);
        this.addStyle(DEFAULT_STYLE, null);
    }

    protected SmallAttributeSet createSmallAttributeSet(AttributeSet a) {
        return new SmallAttributeSet(a);
    }

    protected MutableAttributeSet createLargeAttributeSet(AttributeSet a) {
        return new SimpleAttributeSet(a);
    }

    public void addChangeListener(ChangeListener listener) {
        this.styles.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.styles.removeChangeListener(listener);
    }

    public ChangeListener[] getChangeListeners() {
        return this.styles.getChangeListeners();
    }

    public Style addStyle(String name, Style parent) {
        NamedStyle newStyle = new NamedStyle(name, parent);
        if (name != null) {
            this.styles.addAttribute(name, newStyle);
        }
        return newStyle;
    }

    public void removeStyle(String name) {
        this.styles.removeAttribute(name);
    }

    public Style getStyle(String name) {
        return (Style)this.styles.getAttribute(name);
    }

    public Enumeration<?> getStyleNames() {
        return this.styles.getAttributeNames();
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        this.search = new SimpleAttributeSet();
        this.attributeSetPool = Collections.synchronizedMap(new WeakHashMap());
        in.defaultReadObject();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.cleanupPool();
        out.defaultWriteObject();
    }

    public Font getFont(AttributeSet attr) {
        String family = StyleConstants.getFontFamily(attr);
        int style = 0;
        if (StyleConstants.isBold(attr)) {
            ++style;
        }
        if (StyleConstants.isItalic(attr)) {
            style += 2;
        }
        int size = StyleConstants.getFontSize(attr);
        return this.getFont(family, style, size);
    }

    public Font getFont(String family, int style, int size) {
        SimpleFontSpec spec = new SimpleFontSpec(family, style, size);
        if (sharedFonts.containsKey(spec)) {
            return (Font)sharedFonts.get(spec);
        }
        Font tmp = new Font(family, style, size);
        sharedFonts.put(spec, tmp);
        return tmp;
    }

    public FontMetrics getFontMetrics(Font f) {
        return Toolkit.getDefaultToolkit().getFontMetrics(f);
    }

    public Color getForeground(AttributeSet a) {
        return StyleConstants.getForeground(a);
    }

    public Color getBackground(AttributeSet a) {
        return StyleConstants.getBackground(a);
    }

    protected int getCompressionThreshold() {
        return 9;
    }

    public static StyleContext getDefaultStyleContext() {
        if (defaultStyleContext == null) {
            defaultStyleContext = new StyleContext();
        }
        return defaultStyleContext;
    }

    @Override
    public synchronized AttributeSet addAttribute(AttributeSet old, Object name, Object value) {
        AttributeSet ret;
        if (old.getAttributeCount() + 1 < this.getCompressionThreshold()) {
            this.search.removeAttributes(this.search);
            this.search.addAttributes(old);
            this.search.addAttribute(name, value);
            this.reclaim(old);
            ret = this.searchImmutableSet();
        } else {
            MutableAttributeSet mas = this.getMutableAttributeSet(old);
            mas.addAttribute(name, value);
            ret = mas;
        }
        return ret;
    }

    @Override
    public synchronized AttributeSet addAttributes(AttributeSet old, AttributeSet attributes) {
        AttributeSet ret;
        if (old.getAttributeCount() + attributes.getAttributeCount() < this.getCompressionThreshold()) {
            this.search.removeAttributes(this.search);
            this.search.addAttributes(old);
            this.search.addAttributes(attributes);
            this.reclaim(old);
            ret = this.searchImmutableSet();
        } else {
            MutableAttributeSet mas = this.getMutableAttributeSet(old);
            mas.addAttributes(attributes);
            ret = mas;
        }
        return ret;
    }

    @Override
    public AttributeSet getEmptySet() {
        return SimpleAttributeSet.EMPTY;
    }

    @Override
    public void reclaim(AttributeSet attributes) {
        this.cleanupPool();
    }

    @Override
    public synchronized AttributeSet removeAttribute(AttributeSet old, Object name) {
        AttributeSet ret;
        if (old.getAttributeCount() - 1 <= this.getCompressionThreshold()) {
            this.search.removeAttributes(this.search);
            this.search.addAttributes(old);
            this.search.removeAttribute(name);
            this.reclaim(old);
            ret = this.searchImmutableSet();
        } else {
            MutableAttributeSet mas = this.getMutableAttributeSet(old);
            mas.removeAttribute(name);
            ret = mas;
        }
        return ret;
    }

    @Override
    public synchronized AttributeSet removeAttributes(AttributeSet old, AttributeSet attributes) {
        AttributeSet ret;
        if (old.getAttributeCount() <= this.getCompressionThreshold()) {
            this.search.removeAttributes(this.search);
            this.search.addAttributes(old);
            this.search.removeAttributes(attributes);
            this.reclaim(old);
            ret = this.searchImmutableSet();
        } else {
            MutableAttributeSet mas = this.getMutableAttributeSet(old);
            mas.removeAttributes(attributes);
            ret = mas;
        }
        return ret;
    }

    @Override
    public synchronized AttributeSet removeAttributes(AttributeSet old, Enumeration<?> names) {
        AttributeSet ret;
        if (old.getAttributeCount() <= this.getCompressionThreshold()) {
            this.search.removeAttributes(this.search);
            this.search.addAttributes(old);
            this.search.removeAttributes(names);
            this.reclaim(old);
            ret = this.searchImmutableSet();
        } else {
            MutableAttributeSet mas = this.getMutableAttributeSet(old);
            mas.removeAttributes(names);
            ret = mas;
        }
        return ret;
    }

    public static Object getStaticAttribute(Object key) {
        if (key == null) {
            return null;
        }
        return readAttributeKeys.get(key);
    }

    public static Object getStaticAttributeKey(Object key) {
        return String.valueOf(key.getClass().getName()) + "." + key.toString();
    }

    public static void readAttributeSet(ObjectInputStream in, MutableAttributeSet a) throws ClassNotFoundException, IOException {
        int count = in.readInt();
        int i = 0;
        while (i < count) {
            Object key = in.readObject();
            Object val = in.readObject();
            if (readAttributeKeys != null) {
                Object staticVal;
                Object staticKey = readAttributeKeys.get(key);
                if (staticKey != null) {
                    key = staticKey;
                }
                if ((staticVal = readAttributeKeys.get(val)) != null) {
                    val = staticVal;
                }
            }
            a.addAttribute(key, val);
            ++i;
        }
    }

    public static void writeAttributeSet(ObjectOutputStream out, AttributeSet a) throws IOException {
        int count = a.getAttributeCount();
        out.writeInt(count);
        Enumeration<?> e = a.getAttributeNames();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            if (key instanceof Serializable) {
                out.writeObject(key);
            } else {
                Object io = writeAttributeKeys.get(key);
                if (io == null) {
                    throw new NotSerializableException(String.valueOf(key.getClass().getName()) + ", key: " + key);
                }
                out.writeObject(io);
            }
            Object val = a.getAttribute(key);
            Object io = writeAttributeKeys.get(val);
            if (val instanceof Serializable) {
                out.writeObject(io != null ? io : val);
                continue;
            }
            if (io == null) {
                throw new NotSerializableException(val.getClass().getName());
            }
            out.writeObject(io);
        }
    }

    public void readAttributes(ObjectInputStream in, MutableAttributeSet a) throws ClassNotFoundException, IOException {
        StyleContext.readAttributeSet(in, a);
    }

    public void writeAttributes(ObjectOutputStream out, AttributeSet a) throws IOException {
        StyleContext.writeAttributeSet(out, a);
    }

    public static void registerStaticAttributeKey(Object key) {
        String io = String.valueOf(key.getClass().getName()) + "." + key.toString();
        if (writeAttributeKeys == null) {
            writeAttributeKeys = new Hashtable();
        }
        if (readAttributeKeys == null) {
            readAttributeKeys = new Hashtable();
        }
        writeAttributeKeys.put(key, io);
        readAttributeKeys.put(io, key);
    }

    public String toString() {
        this.cleanupPool();
        StringBuilder b = new StringBuilder();
        for (Object att : this.attributeSetPool.keySet()) {
            b.append(att);
            b.append('\n');
        }
        return b.toString();
    }

    private AttributeSet searchImmutableSet() {
        SmallAttributeSet a;
        SmallAttributeSet k = this.createSmallAttributeSet(this.search);
        WeakReference ref = (WeakReference)this.attributeSetPool.get(k);
        if (ref == null || (a = (SmallAttributeSet)ref.get()) == null) {
            a = k;
            this.attributeSetPool.put(a, new WeakReference<SmallAttributeSet>(a));
        }
        return a;
    }

    private void cleanupPool() {
        this.attributeSetPool.size();
    }

    private MutableAttributeSet getMutableAttributeSet(AttributeSet a) {
        MutableAttributeSet mas = a instanceof MutableAttributeSet ? (MutableAttributeSet)a : this.createLargeAttributeSet(a);
        return mas;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class NamedStyle
    implements Serializable,
    Style {
        private static final long serialVersionUID = -6690628971806226374L;
        protected transient ChangeEvent changeEvent;
        protected EventListenerList listenerList;
        private transient AttributeSet attributes;

        public NamedStyle() {
            this(null, null);
        }

        public NamedStyle(Style parent) {
            this(null, parent);
        }

        public NamedStyle(String name, Style parent) {
            this.attributes = StyleContext.this.getEmptySet();
            this.listenerList = new EventListenerList();
            if (name != null) {
                this.setName(name);
            }
            if (parent != null) {
                this.setResolveParent(parent);
            }
        }

        @Override
        public String getName() {
            String name = null;
            if (this.isDefined(StyleConstants.NameAttribute)) {
                name = this.getAttribute(StyleConstants.NameAttribute).toString();
            }
            return name;
        }

        public void setName(String n) {
            if (n != null) {
                this.addAttribute(StyleConstants.NameAttribute, n);
            }
        }

        @Override
        public void addChangeListener(ChangeListener l) {
            this.listenerList.add(ChangeListener.class, l);
        }

        @Override
        public void removeChangeListener(ChangeListener l) {
            this.listenerList.remove(ChangeListener.class, l);
        }

        public <T extends EventListener> T[] getListeners(Class<T> listenerType) {
            return this.listenerList.getListeners(listenerType);
        }

        public ChangeListener[] getChangeListeners() {
            return (ChangeListener[])this.getListeners(ChangeListener.class);
        }

        protected void fireStateChanged() {
            ChangeListener[] listeners = this.getChangeListeners();
            int i = 0;
            while (i < listeners.length) {
                if (this.changeEvent == null) {
                    this.changeEvent = new ChangeEvent(this);
                }
                listeners[i].stateChanged(this.changeEvent);
                ++i;
            }
        }

        @Override
        public void addAttribute(Object name, Object value) {
            this.attributes = StyleContext.this.addAttribute(this.attributes, name, value);
            this.fireStateChanged();
        }

        @Override
        public void addAttributes(AttributeSet attr) {
            this.attributes = StyleContext.this.addAttributes(this.attributes, attr);
            this.fireStateChanged();
        }

        @Override
        public boolean containsAttribute(Object name, Object value) {
            return this.attributes.containsAttribute(name, value);
        }

        @Override
        public boolean containsAttributes(AttributeSet attrs) {
            return this.attributes.containsAttributes(attrs);
        }

        @Override
        public AttributeSet copyAttributes() {
            NamedStyle copy = new NamedStyle();
            copy.attributes = this.attributes.copyAttributes();
            return copy;
        }

        @Override
        public Object getAttribute(Object attrName) {
            return this.attributes.getAttribute(attrName);
        }

        @Override
        public int getAttributeCount() {
            return this.attributes.getAttributeCount();
        }

        @Override
        public Enumeration<?> getAttributeNames() {
            return this.attributes.getAttributeNames();
        }

        @Override
        public boolean isDefined(Object attrName) {
            return this.attributes.isDefined(attrName);
        }

        @Override
        public boolean isEqual(AttributeSet attr) {
            return this.attributes.isEqual(attr);
        }

        @Override
        public void removeAttribute(Object name) {
            this.attributes = StyleContext.this.removeAttribute(this.attributes, name);
            this.fireStateChanged();
        }

        @Override
        public void removeAttributes(AttributeSet attrs) {
            this.attributes = StyleContext.this.removeAttributes(this.attributes, attrs);
            this.fireStateChanged();
        }

        @Override
        public void removeAttributes(Enumeration<?> names) {
            this.attributes = StyleContext.this.removeAttributes(this.attributes, names);
            this.fireStateChanged();
        }

        @Override
        public AttributeSet getResolveParent() {
            return this.attributes.getResolveParent();
        }

        @Override
        public void setResolveParent(AttributeSet parent) {
            if (parent != null) {
                this.addAttribute(StyleConstants.ResolveAttribute, parent);
            } else {
                this.removeAttribute(StyleConstants.ResolveAttribute);
            }
        }

        public String toString() {
            return "NamedStyle:" + this.getName() + " " + this.attributes;
        }

        private void writeObject(ObjectOutputStream s) throws IOException {
            s.defaultWriteObject();
            StyleContext.writeAttributeSet(s, this.attributes);
        }

        private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
            s.defaultReadObject();
            this.attributes = SimpleAttributeSet.EMPTY;
            StyleContext.readAttributeSet(s, this);
        }
    }

    private static class SimpleFontSpec {
        String family;
        int style;
        int size;

        public SimpleFontSpec(String family, int style, int size) {
            this.family = family;
            this.style = style;
            this.size = size;
        }

        public boolean equals(Object obj) {
            return obj != null && obj instanceof SimpleFontSpec && ((SimpleFontSpec)obj).family.equals(this.family) && ((SimpleFontSpec)obj).style == this.style && ((SimpleFontSpec)obj).size == this.size;
        }

        public int hashCode() {
            return this.family.hashCode() + this.style + this.size;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class SmallAttributeSet
    implements AttributeSet {
        final Object[] attrs;
        private AttributeSet resolveParent;

        public SmallAttributeSet(AttributeSet a) {
            int n = a.getAttributeCount();
            int i = 0;
            this.attrs = new Object[n * 2];
            Enumeration<?> e = a.getAttributeNames();
            while (e.hasMoreElements()) {
                Object name = e.nextElement();
                Object value = a.getAttribute(name);
                if (name == ResolveAttribute) {
                    this.resolveParent = (AttributeSet)value;
                }
                this.attrs[i++] = name;
                this.attrs[i++] = value;
            }
        }

        public SmallAttributeSet(Object[] a) {
            this.attrs = a;
            int i = 0;
            while (i < this.attrs.length) {
                if (this.attrs[i] == ResolveAttribute) {
                    this.resolveParent = (AttributeSet)this.attrs[i + 1];
                }
                i += 2;
            }
        }

        public Object clone() {
            return this;
        }

        @Override
        public boolean containsAttribute(Object name, Object value) {
            return value.equals(this.getAttribute(name));
        }

        @Override
        public boolean containsAttributes(AttributeSet a) {
            boolean res = true;
            Enumeration<?> e = a.getAttributeNames();
            while (e.hasMoreElements() && res) {
                Object name = e.nextElement();
                res = a.getAttribute(name).equals(this.getAttribute(name));
            }
            return res;
        }

        @Override
        public AttributeSet copyAttributes() {
            return this;
        }

        public boolean equals(Object obj) {
            boolean eq = false;
            if (obj instanceof AttributeSet) {
                AttributeSet atts = (AttributeSet)obj;
                eq = this.getAttributeCount() == atts.getAttributeCount() && this.containsAttributes(atts);
            }
            return eq;
        }

        @Override
        public Object getAttribute(Object key) {
            AttributeSet parent;
            Object att = null;
            if (key == StyleConstants.ResolveAttribute) {
                att = this.resolveParent;
            }
            int i = 0;
            while (i < this.attrs.length && att == null) {
                if (this.attrs[i].equals(key)) {
                    att = this.attrs[i + 1];
                }
                i += 2;
            }
            if (att == null && (parent = this.getResolveParent()) != null) {
                att = parent.getAttribute(key);
            }
            return att;
        }

        @Override
        public int getAttributeCount() {
            return this.attrs.length / 2;
        }

        @Override
        public Enumeration<?> getAttributeNames() {
            return new Enumeration(){
                int i = 0;

                public boolean hasMoreElements() {
                    return this.i < SmallAttributeSet.this.attrs.length;
                }

                public Object nextElement() {
                    this.i += 2;
                    return SmallAttributeSet.this.attrs[this.i - 2];
                }
            };
        }

        @Override
        public AttributeSet getResolveParent() {
            return this.resolveParent;
        }

        public int hashCode() {
            return Arrays.asList(this.attrs).hashCode();
        }

        @Override
        public boolean isDefined(Object key) {
            int i = 0;
            while (i < this.attrs.length) {
                if (this.attrs[i].equals(key)) {
                    return true;
                }
                i += 2;
            }
            return false;
        }

        @Override
        public boolean isEqual(AttributeSet attr) {
            boolean eq = attr instanceof SmallAttributeSet ? attr == this : this.getAttributeCount() == attr.getAttributeCount() && this.containsAttributes(attr);
            return eq;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append('{');
            int i = 0;
            while (i < this.attrs.length) {
                if (this.attrs[i + 1] instanceof AttributeSet) {
                    sb.append(this.attrs[i]);
                    sb.append("=AttributeSet,");
                } else {
                    sb.append(this.attrs[i]);
                    sb.append('=');
                    sb.append(this.attrs[i + 1]);
                    sb.append(',');
                }
                i += 2;
            }
            sb.append("}");
            return sb.toString();
        }
    }
}

