/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicRadioButtonUI;

public class MetalRadioButtonUI
extends BasicRadioButtonUI {
    protected Color focusColor;
    protected Color selectColor;
    protected Color disabledTextColor;

    public static ComponentUI createUI(JComponent component) {
        return new MetalRadioButtonUI();
    }

    public void installDefaults(AbstractButton b) {
        super.installDefaults(b);
        String prefix = this.getPropertyPrefix();
        this.disabledTextColor = UIManager.getColor(String.valueOf(prefix) + "disabledText");
        this.focusColor = UIManager.getColor(String.valueOf(prefix) + "focus");
        this.selectColor = UIManager.getColor(String.valueOf(prefix) + "select");
    }

    protected void uninstallDefaults(AbstractButton b) {
        super.uninstallDefaults(b);
        this.disabledTextColor = null;
        this.focusColor = null;
        this.selectColor = null;
    }

    protected Color getSelectColor() {
        return this.selectColor;
    }

    protected Color getDisabledTextColor() {
        return this.disabledTextColor;
    }

    protected Color getFocusColor() {
        return this.focusColor;
    }

    public void paint(Graphics g, JComponent c) {
        super.paint(g, c);
    }

    protected void paintFocus(Graphics g, Rectangle t, Dimension d) {
        g.setColor(this.focusColor);
        g.drawRect(t.x - 1, t.y - 1, t.width + 1, t.height + 1);
    }
}

