/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.beans.PropertyChangeEvent;
import javax.swing.JComponent;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTextUI;
import javax.swing.plaf.basic.SharedUIDefaults;
import javax.swing.text.Element;
import javax.swing.text.FieldView;
import javax.swing.text.View;

public class BasicTextFieldUI
extends BasicTextUI {
    public View create(Element elem) {
        return new FieldView(elem);
    }

    public static ComponentUI createUI(JComponent c) {
        return new BasicTextFieldUI();
    }

    protected String getPropertyPrefix() {
        return "TextField";
    }

    public void installUI(JComponent c) {
        super.installUI(c);
    }

    protected void propertyChange(PropertyChangeEvent event) {
        if (event.getPropertyName().equals("editable") && this.textComponent.getBackground() instanceof ColorUIResource) {
            Color c = null;
            Color old = this.textComponent.getBackground();
            String prefix = this.getPropertyPrefix();
            if (!this.textComponent.isEnabled()) {
                c = SharedUIDefaults.getColor(String.valueOf(prefix) + ".disabledBackground");
            }
            if (c == null && !this.textComponent.isEditable()) {
                c = SharedUIDefaults.getColor(String.valueOf(prefix) + ".inactiveBackground");
            }
            if (c == null) {
                c = SharedUIDefaults.getColor(String.valueOf(prefix) + ".background");
            }
            if (c != null && c != old) {
                this.textComponent.setBackground(c);
            }
        }
    }
}

