/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.ButtonModel;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentInputMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.RootPaneUI;

public class BasicRootPaneUI
extends RootPaneUI
implements PropertyChangeListener {
    public static ComponentUI createUI(JComponent x) {
        return new BasicRootPaneUI();
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        if (c instanceof JRootPane) {
            JRootPane rp = (JRootPane)c;
            this.installDefaults(rp);
            this.installComponents(rp);
            this.installListeners(rp);
            this.installKeyboardActions(rp);
        }
    }

    protected void installDefaults(JRootPane rp) {
    }

    protected void installComponents(JRootPane rp) {
    }

    protected void installListeners(JRootPane rp) {
        rp.addPropertyChangeListener(this);
    }

    protected void installKeyboardActions(JRootPane rp) {
        ActionMapUIResource am = new ActionMapUIResource();
        am.put("press", new DefaultPressAction(rp));
        am.put("release", new DefaultReleaseAction(rp));
        SwingUtilities.replaceUIActionMap(rp, am);
        ComponentInputMapUIResource im = new ComponentInputMapUIResource(rp);
        SwingUtilities.replaceUIInputMap(rp, 2, im);
    }

    public void propertyChange(PropertyChangeEvent event) {
        JRootPane source = (JRootPane)event.getSource();
        String propertyName = event.getPropertyName();
        if (propertyName.equals("defaultButton")) {
            Object newValue = event.getNewValue();
            InputMap im = SwingUtilities.getUIInputMap(source, 2);
            if (newValue != null) {
                Object[] keybindings = (Object[])UIManager.get("RootPane.defaultButtonWindowKeyBindings");
                LookAndFeel.loadKeyBindings(im, keybindings);
            } else {
                im.clear();
            }
        }
    }

    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        if (c instanceof JRootPane) {
            JRootPane rp = (JRootPane)c;
            this.uninstallDefaults(rp);
            this.uninstallComponents(rp);
            this.uninstallListeners(rp);
            this.uninstallKeyboardActions(rp);
        }
    }

    protected void uninstallDefaults(JRootPane rp) {
    }

    protected void uninstallComponents(JRootPane rp) {
    }

    protected void uninstallListeners(JRootPane rp) {
        rp.removePropertyChangeListener(this);
    }

    protected void uninstallKeyboardActions(JRootPane rp) {
        SwingUtilities.replaceUIActionMap(rp, null);
        SwingUtilities.replaceUIInputMap(rp, 2, null);
    }

    private class DefaultPressAction
    extends AbstractAction {
        private JRootPane rootPane;

        DefaultPressAction(JRootPane rp) {
            this.rootPane = rp;
        }

        public void actionPerformed(ActionEvent ev) {
            JButton b = this.rootPane.getDefaultButton();
            if (b != null) {
                ButtonModel m = b.getModel();
                m.setArmed(true);
                m.setPressed(true);
            }
        }
    }

    private class DefaultReleaseAction
    extends AbstractAction {
        private JRootPane rootPane;

        DefaultReleaseAction(JRootPane rp) {
            this.rootPane = rp;
        }

        public void actionPerformed(ActionEvent ev) {
            JButton b = this.rootPane.getDefaultButton();
            if (b != null) {
                ButtonModel m = b.getModel();
                m.setPressed(false);
                m.setArmed(false);
            }
        }
    }
}

