/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.geom.AffineTransform;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JProgressBar;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.ProgressBarUI;

public class BasicProgressBarUI
extends ProgressBarUI {
    protected Rectangle boxRect;
    private transient Timer animationTimer;
    private transient int animationIndex;
    private transient int numFrames;
    private transient Animator animation;
    private transient PropertyChangeHandler propertyListener;
    protected ChangeListener changeListener;
    protected JProgressBar progressBar;
    transient double boxDependent = -1.0;
    transient int boxIndependent = -1;
    transient double incr = -1.0;
    private transient int cellLength;
    private transient int cellSpacing;
    private transient Color selectionBackground;
    private transient Color selectionForeground;
    private AncestorListener ancestorListener;
    private ComponentListener componentListener;

    public static ComponentUI createUI(JComponent x) {
        return new BasicProgressBarUI();
    }

    protected int getAmountFull(Insets b, int width, int height) {
        double percentDone = this.progressBar.getPercentComplete();
        if (this.progressBar.getOrientation() == 0) {
            return (int)(percentDone * (double)(width - b.left - b.right));
        }
        return (int)(percentDone * (double)(height - b.top - b.bottom));
    }

    protected int getAnimationIndex() {
        return this.animationIndex;
    }

    protected Rectangle getBox(Rectangle r) {
        if (!this.progressBar.isIndeterminate()) {
            return null;
        }
        if (r == null) {
            r = new Rectangle();
        }
        Rectangle vr = new Rectangle();
        SwingUtilities.calculateInnerArea(this.progressBar, vr);
        if (this.incr == -1.0 || this.boxDependent == -1.0 || this.boxIndependent == -1) {
            int iterations = this.numFrames / 2;
            if (this.progressBar.getOrientation() == 0) {
                this.boxDependent = (double)vr.width / 6.0;
                this.incr = ((double)vr.width - this.boxDependent) / (double)iterations;
                this.boxIndependent = vr.height;
            } else {
                this.boxDependent = (double)vr.height / 6.0;
                this.incr = ((double)vr.height - this.boxDependent) / (double)iterations;
                this.boxIndependent = vr.width;
            }
        }
        int index = this.getAnimationIndex();
        if (this.animationIndex > this.numFrames / 2) {
            index = this.numFrames - this.getAnimationIndex();
        }
        if (this.progressBar.getOrientation() == 0) {
            r.x = vr.x + (int)(this.incr * (double)index);
            r.y = vr.y;
            r.width = (int)this.boxDependent;
            r.height = this.boxIndependent;
        } else {
            r.x = vr.x;
            r.y = vr.height - (int)(this.incr * (double)index) + vr.y - (int)this.boxDependent;
            r.width = this.boxIndependent;
            r.height = (int)this.boxDependent;
        }
        return r;
    }

    protected int getCellLength() {
        return this.cellLength;
    }

    protected int getCellSpacing() {
        return this.cellSpacing;
    }

    public Dimension getMaximumSize(JComponent c) {
        Dimension ret;
        Insets insets = c.getInsets();
        int orientation = this.progressBar.getOrientation();
        if (orientation == 1) {
            ret = this.getPreferredInnerVertical();
            ret.height = Short.MAX_VALUE;
            ret.width += insets.left + insets.right;
        } else {
            ret = this.getPreferredInnerHorizontal();
            ret.width = Short.MAX_VALUE;
            ret.height += insets.top + insets.bottom;
        }
        return ret;
    }

    public Dimension getMinimumSize(JComponent c) {
        Dimension ret;
        Insets insets = c.getInsets();
        int orientation = this.progressBar.getOrientation();
        if (orientation == 1) {
            ret = this.getPreferredInnerVertical();
            ret.height = 10;
            ret.width += insets.left + insets.right;
        } else {
            ret = this.getPreferredInnerHorizontal();
            ret.width = 10;
            ret.height += insets.top + insets.bottom;
        }
        return ret;
    }

    protected Dimension getPreferredInnerHorizontal() {
        Font font = this.progressBar.getFont();
        FontMetrics fm = this.progressBar.getFontMetrics(font);
        int stringWidth = 0;
        String str = this.progressBar.getString();
        if (str != null) {
            stringWidth = fm.stringWidth(this.progressBar.getString());
        }
        Insets i = this.progressBar.getInsets();
        int prefWidth = Math.max(200 - i.left - i.right, stringWidth);
        int stringHeight = 0;
        if (str != null) {
            stringHeight = fm.getHeight();
        }
        int prefHeight = Math.max(16 - i.top - i.bottom, stringHeight);
        return new Dimension(prefWidth, prefHeight);
    }

    protected Dimension getPreferredInnerVertical() {
        Font font = this.progressBar.getFont();
        FontMetrics fm = this.progressBar.getFontMetrics(font);
        int stringWidth = 0;
        String str = this.progressBar.getString();
        if (str != null) {
            stringWidth = fm.stringWidth(this.progressBar.getString());
        }
        Insets i = this.progressBar.getInsets();
        int prefHeight = Math.max(200 - i.left - i.right, stringWidth);
        int stringHeight = 0;
        if (str != null) {
            stringHeight = fm.getHeight();
        }
        int prefWidth = Math.max(16 - i.top - i.bottom, stringHeight);
        return new Dimension(prefWidth, prefHeight);
    }

    public Dimension getPreferredSize(JComponent c) {
        Insets insets = c.getInsets();
        int orientation = this.progressBar.getOrientation();
        Dimension ret = orientation == 1 ? this.getPreferredInnerVertical() : this.getPreferredInnerHorizontal();
        ret.width += insets.left + insets.right;
        ret.height += insets.top + insets.bottom;
        return ret;
    }

    protected Color getSelectionBackground() {
        return this.selectionBackground;
    }

    protected Color getSelectionForeground() {
        return this.selectionForeground;
    }

    protected Point getStringPlacement(Graphics g, String progressString, int x, int y, int width, int height) {
        Rectangle tr = new Rectangle();
        Rectangle vr = new Rectangle();
        Rectangle ir = new Rectangle();
        if (this.progressBar.getOrientation() == 0) {
            vr.setBounds(x, y, width, height);
        } else {
            vr.setBounds(y, x, height, width);
        }
        Font f = g.getFont();
        FontMetrics fm = g.getFontMetrics(f);
        SwingUtilities.layoutCompoundLabel(this.progressBar, fm, progressString, null, 0, 0, 0, 0, vr, ir, tr, 0);
        if (this.progressBar.getOrientation() == 0) {
            return new Point(tr.x, tr.y);
        }
        return new Point(tr.y, tr.x);
    }

    protected void incrementAnimationIndex() {
        ++this.animationIndex;
        if (this.animationIndex >= this.numFrames) {
            this.animationIndex = 0;
        }
        this.progressBar.repaint();
    }

    public void paint(Graphics g, JComponent c) {
        if (!this.progressBar.isIndeterminate()) {
            this.paintDeterminate(g, c);
        } else {
            this.paintIndeterminate(g, c);
        }
    }

    protected void paintDeterminate(Graphics g, JComponent c) {
        Color saved = g.getColor();
        this.getCellSpacing();
        this.getCellLength();
        this.progressBar.getMaximum();
        this.progressBar.getMinimum();
        this.progressBar.getValue();
        Rectangle vr = SwingUtilities.calculateInnerArea(c, new Rectangle());
        Rectangle or = this.progressBar.getBounds();
        Insets insets = c.getInsets();
        int amountFull = this.getAmountFull(insets, or.width, or.height);
        if (this.progressBar.getOrientation() == 0) {
            g.setColor(c.getForeground());
            g.fillRect(vr.x, vr.y, amountFull, vr.height);
        } else {
            g.setColor(c.getForeground());
            g.fillRect(vr.x, vr.y + vr.height - amountFull, vr.width, amountFull);
        }
        if (this.progressBar.isStringPainted() && !this.progressBar.getString().equals("")) {
            this.paintString(g, 0, 0, or.width, or.height, amountFull, insets);
        }
        g.setColor(saved);
    }

    protected void paintIndeterminate(Graphics g, JComponent c) {
        Color saved = g.getColor();
        Insets insets = c.getInsets();
        Rectangle or = c.getBounds();
        Rectangle vr = new Rectangle();
        SwingUtilities.calculateInnerArea(c, vr);
        g.setColor(c.getBackground());
        g.fillRect(vr.x, vr.y, vr.width, vr.height);
        this.boxRect = this.getBox(this.boxRect);
        g.setColor(c.getForeground());
        g.fillRect(this.boxRect.x, this.boxRect.y, this.boxRect.width, this.boxRect.height);
        if (this.progressBar.isStringPainted() && !this.progressBar.getString().equals("")) {
            this.paintString(g, 0, 0, or.width, or.height, this.getAmountFull(insets, or.width, or.height), insets);
        }
        g.setColor(saved);
    }

    protected void paintString(Graphics g, int x, int y, int width, int height, int amountFull, Insets b) {
        String str = this.progressBar.getString();
        int full = this.getAmountFull(b, width, height);
        Point placement = this.getStringPlacement(g, this.progressBar.getString(), x + b.left, y + b.top, width - b.left - b.right, height - b.top - b.bottom);
        Color savedColor = g.getColor();
        Shape savedClip = g.getClip();
        FontMetrics fm = g.getFontMetrics(this.progressBar.getFont());
        if (this.progressBar.getOrientation() == 1) {
            AffineTransform rotate = AffineTransform.getRotateInstance(1.5707963267948966);
            g.setFont(this.progressBar.getFont().deriveFont(rotate));
            placement.x = width - placement.x - fm.getAscent();
        } else {
            placement.y += fm.getAscent();
        }
        g.setColor(this.getSelectionForeground());
        g.setClip(0, 0, full + b.left, height);
        g.drawString(str, placement.x, placement.y);
        g.setColor(this.getSelectionBackground());
        g.setClip(full + b.left, 0, width - full, height);
        g.drawString(str, placement.x, placement.y);
        g.setClip(savedClip);
        g.setColor(savedColor);
    }

    protected void setAnimationIndex(int newValue) {
        this.animationIndex = newValue <= this.numFrames ? newValue : 0;
        this.progressBar.repaint();
    }

    protected void setCellLength(int cellLen) {
        this.cellLength = cellLen;
    }

    protected void setCellSpacing(int cellSpace) {
        this.cellSpacing = cellSpace;
    }

    protected void startAnimationTimer() {
        if (this.animationTimer != null) {
            this.animationTimer.start();
        }
    }

    protected void stopAnimationTimer() {
        if (this.animationTimer != null) {
            this.animationTimer.stop();
        }
        this.setAnimationIndex(0);
    }

    protected void installDefaults() {
        LookAndFeel.installColorsAndFont(this.progressBar, "ProgressBar.background", "ProgressBar.foreground", "ProgressBar.font");
        LookAndFeel.installBorder(this.progressBar, "ProgressBar.border");
        this.progressBar.setOpaque(true);
        this.selectionForeground = UIManager.getColor("ProgressBar.selectionForeground");
        this.selectionBackground = UIManager.getColor("ProgressBar.selectionBackground");
        this.cellLength = UIManager.getInt("ProgressBar.cellLength");
        this.cellSpacing = UIManager.getInt("ProgressBar.cellSpacing");
        int repaintInterval = UIManager.getInt("ProgressBar.repaintInterval");
        int cycleTime = UIManager.getInt("ProgressBar.cycleTime");
        if (cycleTime % repaintInterval != 0 && cycleTime / repaintInterval % 2 != 0) {
            int div = cycleTime / repaintInterval + 2;
            div /= 2;
            cycleTime = (div *= 2) * repaintInterval;
        }
        this.setAnimationIndex(0);
        this.numFrames = cycleTime / repaintInterval;
        this.animationTimer.setDelay(repaintInterval);
    }

    protected void uninstallDefaults() {
        this.progressBar.setFont(null);
        this.progressBar.setForeground(null);
        this.progressBar.setBackground(null);
        this.selectionForeground = null;
        this.selectionBackground = null;
    }

    protected void installListeners() {
        this.changeListener = new ChangeHandler();
        this.propertyListener = new PropertyChangeHandler();
        this.animation = new Animator();
        this.progressBar.addChangeListener(this.changeListener);
        this.progressBar.addPropertyChangeListener(this.propertyListener);
        this.animationTimer.addActionListener(this.animation);
        this.ancestorListener = new AncestorHandler();
        this.progressBar.addAncestorListener(this.ancestorListener);
        this.componentListener = new ComponentHandler();
        this.progressBar.addComponentListener(this.componentListener);
    }

    protected void uninstallListeners() {
        this.progressBar.removeChangeListener(this.changeListener);
        this.progressBar.removePropertyChangeListener(this.propertyListener);
        this.animationTimer.removeActionListener(this.animation);
        this.changeListener = null;
        this.propertyListener = null;
        this.animation = null;
        if (this.ancestorListener != null) {
            this.progressBar.removeAncestorListener(this.ancestorListener);
        }
        this.ancestorListener = null;
        if (this.componentListener != null) {
            this.progressBar.removeComponentListener(this.componentListener);
        }
        this.componentListener = null;
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        if (c instanceof JProgressBar) {
            this.progressBar = (JProgressBar)c;
            this.animationTimer = new Timer(200, null);
            this.animationTimer.setRepeats(true);
            this.installDefaults();
            this.installListeners();
        }
        if (this.progressBar.isIndeterminate()) {
            this.startAnimationTimer();
        }
    }

    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        this.uninstallListeners();
        this.uninstallDefaults();
        this.animationTimer = null;
        this.progressBar = null;
    }

    private class AncestorHandler
    implements AncestorListener {
        private AncestorHandler() {
        }

        public void ancestorAdded(AncestorEvent event) {
            if (BasicProgressBarUI.this.progressBar.isIndeterminate()) {
                BasicProgressBarUI.this.startAnimationTimer();
            }
        }

        public void ancestorRemoved(AncestorEvent event) {
            BasicProgressBarUI.this.stopAnimationTimer();
        }

        public void ancestorMoved(AncestorEvent event) {
        }
    }

    private class Animator
    implements ActionListener {
        private Animator() {
        }

        public void actionPerformed(ActionEvent e) {
            BasicProgressBarUI.this.incrementAnimationIndex();
        }
    }

    public class ChangeHandler
    implements ChangeListener {
        public void stateChanged(ChangeEvent e) {
            BasicProgressBarUI.this.progressBar.repaint();
        }
    }

    private class ComponentHandler
    extends ComponentAdapter {
        private ComponentHandler() {
        }

        public void componentResized(ComponentEvent e) {
            BasicProgressBarUI.this.boxDependent = -1.0;
            BasicProgressBarUI.this.boxIndependent = -1;
            BasicProgressBarUI.this.incr = -1.0;
        }
    }

    private class PropertyChangeHandler
    implements PropertyChangeListener {
        private PropertyChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName().equals("indeterminate")) {
                if (((Boolean)e.getNewValue()).booleanValue() && BasicProgressBarUI.this.progressBar.isShowing()) {
                    BasicProgressBarUI.this.startAnimationTimer();
                } else {
                    BasicProgressBarUI.this.stopAnimationTimer();
                }
            }
        }
    }
}

