/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ButtonUI;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.text.View;

public class BasicButtonUI
extends ButtonUI {
    static Rectangle viewR = new Rectangle();
    static Rectangle iconR = new Rectangle();
    static Rectangle textR = new Rectangle();
    static Insets cachedInsets;
    private static BasicButtonUI sharedUI;
    private static BasicButtonListener sharedListener;
    protected int defaultTextIconGap = 4;
    protected int defaultTextShiftOffset;
    private int textShiftOffset;

    public static ComponentUI createUI(JComponent c) {
        if (sharedUI == null) {
            sharedUI = new BasicButtonUI();
        }
        return sharedUI;
    }

    public int getDefaultTextIconGap(AbstractButton b) {
        return this.defaultTextIconGap;
    }

    protected void clearTextShiftOffset() {
        this.textShiftOffset = 0;
    }

    protected int getTextShiftOffset() {
        return this.textShiftOffset;
    }

    protected void setTextShiftOffset() {
        this.textShiftOffset = this.defaultTextShiftOffset;
    }

    protected String getPropertyPrefix() {
        return "Button.";
    }

    protected void installDefaults(AbstractButton b) {
        Object rollover;
        String prefix = this.getPropertyPrefix();
        LookAndFeel.installColorsAndFont(b, String.valueOf(prefix) + "background", String.valueOf(prefix) + "foreground", String.valueOf(prefix) + "font");
        LookAndFeel.installBorder(b, String.valueOf(prefix) + "border");
        if (b.getMargin() == null || b.getMargin() instanceof UIResource) {
            b.setMargin(UIManager.getInsets(String.valueOf(prefix) + "margin"));
        }
        if ((rollover = UIManager.get(String.valueOf(prefix) + "rollover")) != null) {
            LookAndFeel.installProperty(b, "rolloverEnabled", rollover);
        }
        this.defaultTextShiftOffset = UIManager.getInt(String.valueOf(prefix) + "textShiftOffset");
        if (b.isContentAreaFilled()) {
            LookAndFeel.installProperty(b, "opaque", Boolean.TRUE);
        } else {
            LookAndFeel.installProperty(b, "opaque", Boolean.FALSE);
        }
    }

    protected void uninstallDefaults(AbstractButton b) {
        LookAndFeel.uninstallBorder(b);
    }

    protected BasicButtonListener createButtonListener(AbstractButton b) {
        if (sharedListener == null) {
            sharedListener = new BasicButtonListener(b);
        }
        return sharedListener;
    }

    protected void installListeners(AbstractButton b) {
        BasicButtonListener listener = this.createButtonListener(b);
        if (listener != null) {
            b.addChangeListener(listener);
            b.addPropertyChangeListener(listener);
            b.addFocusListener(listener);
            b.addMouseListener(listener);
            b.addMouseMotionListener(listener);
        }
        listener.propertyChange(new PropertyChangeEvent(b, "font", null, b.getFont()));
    }

    protected void uninstallListeners(AbstractButton b) {
        BasicButtonListener listener = this.getButtonListener(b);
        if (listener != null) {
            b.removeChangeListener(listener);
            b.removePropertyChangeListener(listener);
            b.removeFocusListener(listener);
            b.removeMouseListener(listener);
            b.removeMouseMotionListener(listener);
        }
    }

    protected void installKeyboardActions(AbstractButton b) {
        BasicButtonListener listener = this.getButtonListener(b);
        if (listener != null) {
            listener.installKeyboardActions(b);
        }
    }

    protected void uninstallKeyboardActions(AbstractButton b) {
        BasicButtonListener listener = this.getButtonListener(b);
        if (listener != null) {
            listener.uninstallKeyboardActions(b);
        }
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        if (c instanceof AbstractButton) {
            AbstractButton b = (AbstractButton)c;
            this.installDefaults(b);
            this.installListeners(b);
            this.installKeyboardActions(b);
            BasicHTML.updateRenderer(b, b.getText());
        }
    }

    public void uninstallUI(JComponent c) {
        if (c instanceof AbstractButton) {
            AbstractButton b = (AbstractButton)c;
            this.uninstallKeyboardActions(b);
            this.uninstallListeners(b);
            this.uninstallDefaults(b);
            BasicHTML.updateRenderer(b, "");
            b.putClientProperty("BasicGraphicsUtils.cachedTextLayout", null);
        }
    }

    public Dimension getMinimumSize(JComponent c) {
        Dimension size = this.getPreferredSize(c);
        View html = (View)c.getClientProperty("html");
        if (html != null) {
            size.width = (int)((float)size.width - (html.getPreferredSpan(0) - html.getPreferredSpan(0)));
        }
        return size;
    }

    public Dimension getMaximumSize(JComponent c) {
        Dimension size = this.getPreferredSize(c);
        View html = (View)c.getClientProperty("html");
        if (html != null) {
            size.width = (int)((float)size.width + (html.getMaximumSpan(0) - html.getPreferredSpan(0)));
        }
        return size;
    }

    public Dimension getPreferredSize(JComponent c) {
        AbstractButton b = (AbstractButton)c;
        Dimension d = BasicGraphicsUtils.getPreferredButtonSize(b, b.getIconTextGap());
        return d;
    }

    static Icon currentIcon(AbstractButton b) {
        Icon i = b.getIcon();
        ButtonModel model = b.getModel();
        if (model.isPressed() && b.getPressedIcon() != null && b.isEnabled()) {
            i = b.getPressedIcon();
        } else if (model.isRollover()) {
            if (b.isSelected() && b.getRolloverSelectedIcon() != null) {
                i = b.getRolloverSelectedIcon();
            } else if (b.getRolloverIcon() != null) {
                i = b.getRolloverIcon();
            }
        } else if (b.isSelected() && b.isEnabled()) {
            if (b.isEnabled() && b.getSelectedIcon() != null) {
                i = b.getSelectedIcon();
            } else if (b.getDisabledSelectedIcon() != null) {
                i = b.getDisabledSelectedIcon();
            }
        } else if (!b.isEnabled() && b.getDisabledIcon() != null) {
            i = b.getDisabledIcon();
        }
        return i;
    }

    public void paint(Graphics g, JComponent c) {
        AbstractButton b = (AbstractButton)c;
        Insets i = c.getInsets(cachedInsets);
        BasicButtonUI.viewR.x = i.left;
        BasicButtonUI.viewR.y = i.top;
        BasicButtonUI.viewR.width = c.getWidth() - i.left - i.right;
        BasicButtonUI.viewR.height = c.getHeight() - i.top - i.bottom;
        BasicButtonUI.textR.x = 0;
        BasicButtonUI.textR.y = 0;
        BasicButtonUI.textR.width = 0;
        BasicButtonUI.textR.height = 0;
        BasicButtonUI.iconR.x = 0;
        BasicButtonUI.iconR.y = 0;
        BasicButtonUI.iconR.width = 0;
        BasicButtonUI.iconR.height = 0;
        Font f = c.getFont();
        g.setFont(f);
        Icon icon = b.getIcon();
        String text = b.getText();
        text = SwingUtilities.layoutCompoundLabel(c, g.getFontMetrics(f), text, icon, b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), viewR, iconR, textR, text == null ? 0 : b.getIconTextGap());
        ButtonModel model = b.getModel();
        if (model.isArmed() && model.isPressed()) {
            this.paintButtonPressed(g, b);
        }
        if (icon != null) {
            this.paintIcon(g, c, iconR);
        }
        if (text != null) {
            View html = (View)b.getClientProperty("html");
            if (html != null) {
                html.paint(g, textR);
            } else {
                this.paintText(g, b, textR, text);
            }
        }
        if (b.isFocusOwner() && b.isFocusPainted()) {
            this.paintFocus(g, b, viewR, textR, iconR);
        }
    }

    protected void paintFocus(Graphics g, AbstractButton b, Rectangle vr, Rectangle tr, Rectangle ir) {
    }

    protected void paintIcon(Graphics g, JComponent c, Rectangle iconRect) {
        AbstractButton b = (AbstractButton)c;
        Icon i = BasicButtonUI.currentIcon(b);
        if (i != null) {
            ButtonModel m = b.getModel();
            if (m.isPressed() && m.isArmed()) {
                int offs = this.getTextShiftOffset();
                i.paintIcon(c, g, iconRect.x + offs, iconRect.y + offs);
            } else {
                i.paintIcon(c, g, iconRect.x, iconRect.y);
            }
        }
    }

    protected void paintButtonPressed(Graphics g, AbstractButton b) {
        if (b.isContentAreaFilled() && b.isOpaque()) {
            Rectangle area = new Rectangle();
            SwingUtilities.calculateInnerArea(b, area);
            g.setColor(UIManager.getColor(String.valueOf(this.getPropertyPrefix()) + "shadow"));
            g.fillRect(area.x, area.y, area.width, area.height);
        }
    }

    protected void paintText(Graphics g, JComponent c, Rectangle textRect, String text) {
        AbstractButton b = (AbstractButton)c;
        Font f = b.getFont();
        g.setFont(f);
        FontMetrics fm = g.getFontMetrics(f);
        if (b.isEnabled()) {
            g.setColor(b.getForeground());
            BasicGraphicsUtils.drawString(b, g, text, -1, textRect.x, textRect.y + fm.getAscent());
        } else {
            String prefix = this.getPropertyPrefix();
            g.setColor(UIManager.getColor(String.valueOf(prefix) + "disabledText"));
            BasicGraphicsUtils.drawString(b, g, text, -1, textRect.x, textRect.y + fm.getAscent());
        }
    }

    protected void paintText(Graphics g, AbstractButton b, Rectangle textRect, String text) {
        this.paintText(g, (JComponent)b, textRect, text);
    }

    private BasicButtonListener getButtonListener(AbstractButton b) {
        PropertyChangeListener[] listeners = b.getPropertyChangeListeners();
        BasicButtonListener l = null;
        int i = 0;
        while (listeners != null && l == null && i < listeners.length) {
            if (listeners[i] instanceof BasicButtonListener) {
                l = (BasicButtonListener)listeners[i];
            }
            ++i;
        }
        return l;
    }
}

