/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.IllegalComponentStateException;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.awt.Rectangle;
import java.io.Serializable;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.plaf.RootPaneUI;

public class JRootPane
extends JComponent
implements Accessible {
    private static final long serialVersionUID = 8690748000348575668L;
    public static final int NONE = 0;
    public static final int FRAME = 1;
    public static final int PLAIN_DIALOG = 2;
    public static final int INFORMATION_DIALOG = 3;
    public static final int ERROR_DIALOG = 4;
    public static final int COLOR_CHOOSER_DIALOG = 5;
    public static final int FILE_CHOOSER_DIALOG = 6;
    public static final int QUESTION_DIALOG = 7;
    public static final int WARNING_DIALOG = 8;
    protected Component glassPane;
    protected JLayeredPane layeredPane;
    protected JMenuBar menuBar;
    protected Container contentPane;
    protected JButton defaultButton;
    protected Action defaultPressAction;
    protected Action defaultReleaseAction;
    private int windowDecorationStyle = 0;

    public void setJMenuBar(JMenuBar m) {
        JLayeredPane jlPane = this.getLayeredPane();
        if (this.menuBar != null) {
            jlPane.remove(this.menuBar);
        }
        this.menuBar = m;
        if (this.menuBar != null) {
            jlPane.add((Component)this.menuBar, JLayeredPane.FRAME_CONTENT_LAYER);
        }
    }

    public void setMenuBar(JMenuBar m) {
        this.setJMenuBar(m);
    }

    public JMenuBar getJMenuBar() {
        return this.menuBar;
    }

    public JMenuBar getMenuBar() {
        return this.getJMenuBar();
    }

    public boolean isValidateRoot() {
        return true;
    }

    public Container getContentPane() {
        if (this.contentPane == null) {
            this.setContentPane(this.createContentPane());
        }
        return this.contentPane;
    }

    public void setContentPane(Container p) {
        if (p == null) {
            throw new IllegalComponentStateException("cannot have a null content pane");
        }
        if (this.contentPane != null && this.contentPane.getParent() == this.layeredPane) {
            this.layeredPane.remove(this.contentPane);
        }
        this.contentPane = p;
        this.getLayeredPane().add((Component)this.contentPane, JLayeredPane.FRAME_CONTENT_LAYER);
    }

    protected void addImpl(Component comp, Object constraints, int index) {
        super.addImpl(comp, constraints, index);
    }

    public Component getGlassPane() {
        if (this.glassPane == null) {
            this.setGlassPane(this.createGlassPane());
        }
        return this.glassPane;
    }

    public void setGlassPane(Component f) {
        if (this.glassPane != null) {
            this.remove(this.glassPane);
        }
        this.glassPane = f;
        this.glassPane.setVisible(false);
        this.add(this.glassPane, 0);
    }

    public JLayeredPane getLayeredPane() {
        if (this.layeredPane == null) {
            this.setLayeredPane(this.createLayeredPane());
        }
        return this.layeredPane;
    }

    public void setLayeredPane(JLayeredPane f) {
        if (f == null) {
            throw new IllegalComponentStateException();
        }
        if (this.layeredPane != null) {
            this.remove(this.layeredPane);
        }
        this.layeredPane = f;
        this.add((Component)f, -1);
    }

    public JRootPane() {
        this.setLayout(this.createRootLayout());
        this.getGlassPane();
        this.getLayeredPane();
        this.getContentPane();
        this.setOpaque(true);
        this.updateUI();
    }

    protected LayoutManager createRootLayout() {
        return new RootLayout();
    }

    protected Container createContentPane() {
        JPanel p = new JPanel();
        p.setName(String.valueOf(this.getName()) + ".contentPane");
        p.setLayout(new BorderLayout());
        return p;
    }

    protected Component createGlassPane() {
        JPanel p = new JPanel();
        p.setName(String.valueOf(this.getName()) + ".glassPane");
        p.setVisible(false);
        p.setOpaque(false);
        return p;
    }

    protected JLayeredPane createLayeredPane() {
        JLayeredPane l = new JLayeredPane();
        l.setLayout(null);
        return l;
    }

    public RootPaneUI getUI() {
        return (RootPaneUI)this.ui;
    }

    public void setUI(RootPaneUI ui) {
        super.setUI(ui);
    }

    public void updateUI() {
        this.setUI((RootPaneUI)UIManager.getUI(this));
    }

    public String getUIClassID() {
        return "RootPaneUI";
    }

    public JButton getDefaultButton() {
        return this.defaultButton;
    }

    public void setDefaultButton(JButton newButton) {
        if (this.defaultButton != newButton && (newButton == null || newButton.isDefaultCapable())) {
            JButton oldButton = this.defaultButton;
            this.defaultButton = newButton;
            this.firePropertyChange("defaultButton", oldButton, newButton);
        }
    }

    public int getWindowDecorationStyle() {
        return this.windowDecorationStyle;
    }

    public void setWindowDecorationStyle(int style) {
        if (style != 0 && style != 1 && style != 3 && style != 4 && style != 5 && style != 6 && style != 7 && style != 8 && style != 2) {
            throw new IllegalArgumentException("invalid style");
        }
        int oldStyle = this.windowDecorationStyle;
        this.windowDecorationStyle = style;
        this.firePropertyChange("windowDecorationStyle", oldStyle, style);
    }

    public boolean isOptimizedDrawingEnable() {
        return !this.glassPane.isVisible();
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJRootPane();
        }
        return this.accessibleContext;
    }

    protected class AccessibleJRootPane
    extends JComponent.AccessibleJComponent {
        private static final long serialVersionUID = 1082432482784468088L;

        protected AccessibleJRootPane() {
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.ROOT_PANE;
        }
    }

    protected class RootLayout
    implements LayoutManager2,
    Serializable {
        private static final long serialVersionUID = -4100116998559815027L;
        private Rectangle glassPaneBounds;
        private Rectangle layeredPaneBounds;
        private Rectangle contentPaneBounds;
        private Rectangle menuBarBounds;

        protected RootLayout() {
        }

        public void addLayoutComponent(Component comp, Object constraints) {
        }

        public void addLayoutComponent(String name, Component comp) {
        }

        public float getLayoutAlignmentX(Container target) {
            return 0.0f;
        }

        public float getLayoutAlignmentY(Container target) {
            return 0.0f;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void invalidateLayout(Container target) {
            RootLayout rootLayout = this;
            synchronized (rootLayout) {
                this.glassPaneBounds = null;
                this.layeredPaneBounds = null;
                this.contentPaneBounds = null;
                this.menuBarBounds = null;
            }
        }

        public void layoutContainer(Container c) {
            if (this.glassPaneBounds == null || this.layeredPaneBounds == null || this.contentPaneBounds == null || this.menuBarBounds == null) {
                Insets i = JRootPane.this.getInsets();
                int containerWidth = c.getBounds().width - i.left - i.right;
                int containerHeight = c.getBounds().height - i.top - i.bottom;
                if (JRootPane.this.menuBar != null) {
                    Dimension menuBarSize = JRootPane.this.menuBar.getPreferredSize();
                    if (menuBarSize.height > containerHeight) {
                        menuBarSize.height = containerHeight;
                    }
                    this.menuBarBounds = new Rectangle(0, 0, containerWidth, menuBarSize.height);
                    this.contentPaneBounds = new Rectangle(0, menuBarSize.height, containerWidth, containerHeight - menuBarSize.height);
                } else {
                    this.contentPaneBounds = new Rectangle(0, 0, containerWidth, containerHeight);
                }
                this.glassPaneBounds = new Rectangle(i.left, i.top, containerWidth, containerHeight);
                this.layeredPaneBounds = new Rectangle(i.left, i.top, containerWidth, containerHeight);
            }
            JRootPane.this.glassPane.setBounds(this.glassPaneBounds);
            JRootPane.this.layeredPane.setBounds(this.layeredPaneBounds);
            if (JRootPane.this.menuBar != null) {
                JRootPane.this.menuBar.setBounds(this.menuBarBounds);
            }
            JRootPane.this.getContentPane().setBounds(this.contentPaneBounds);
        }

        public Dimension maximumLayoutSize(Container target) {
            return this.preferredLayoutSize(target);
        }

        public Dimension minimumLayoutSize(Container target) {
            return this.preferredLayoutSize(target);
        }

        public Dimension preferredLayoutSize(Container c) {
            Dimension prefSize = new Dimension();
            Insets i = JRootPane.this.getInsets();
            prefSize = new Dimension(i.left + i.right, i.top + i.bottom);
            Dimension contentPrefSize = JRootPane.this.getContentPane().getPreferredSize();
            prefSize.width += contentPrefSize.width;
            prefSize.height += contentPrefSize.height;
            if (JRootPane.this.menuBar != null) {
                Dimension menuBarSize = JRootPane.this.menuBar.getPreferredSize();
                if (menuBarSize.width > contentPrefSize.width) {
                    prefSize.width += menuBarSize.width - contentPrefSize.width;
                }
                prefSize.height += menuBarSize.height;
            }
            return prefSize;
        }

        public void removeLayoutComponent(Component comp) {
        }
    }
}

