/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import gnu.classpath.SystemProperties;
import gnu.java.lang.CPStringBuilder;
import gnu.java.locale.LocaleHelper;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.MissingResourceException;
import java.util.PropertyPermission;
import java.util.ResourceBundle;
import java.util.ServiceLoader;
import java.util.spi.LocaleNameProvider;

public final class Locale
implements Serializable,
Cloneable {
    public static final Locale ENGLISH = Locale.getLocale("en");
    public static final Locale FRENCH = Locale.getLocale("fr");
    public static final Locale GERMAN = Locale.getLocale("de");
    public static final Locale ITALIAN = Locale.getLocale("it");
    public static final Locale JAPANESE = Locale.getLocale("ja");
    public static final Locale KOREAN = Locale.getLocale("ko");
    public static final Locale CHINESE = Locale.getLocale("zh");
    public static final Locale SIMPLIFIED_CHINESE = Locale.getLocale("zh", "CN");
    public static final Locale TRADITIONAL_CHINESE = Locale.getLocale("zh", "TW");
    public static final Locale FRANCE = Locale.getLocale("fr", "FR");
    public static final Locale GERMANY = Locale.getLocale("de", "DE");
    public static final Locale ITALY = Locale.getLocale("it", "IT");
    public static final Locale JAPAN = Locale.getLocale("ja", "JP");
    public static final Locale KOREA = Locale.getLocale("ko", "KR");
    public static final Locale CHINA;
    public static final Locale PRC;
    public static final Locale TAIWAN;
    public static final Locale UK;
    public static final Locale US;
    public static final Locale CANADA;
    public static final Locale CANADA_FRENCH;
    public static final Locale ROOT;
    private static final long serialVersionUID = 9149081749638150636L;
    private final String language;
    private final String country;
    private final String variant;
    private int hashcode;
    private static transient Locale[] availableLocales;
    private static transient HashMap localeMap;
    private static Locale defaultLocale;
    private static transient String[] languageCache;
    private static transient String[] countryCache;

    static {
        PRC = CHINA = SIMPLIFIED_CHINESE;
        TAIWAN = TRADITIONAL_CHINESE;
        UK = Locale.getLocale("en", "GB");
        US = Locale.getLocale("en", "US");
        CANADA = Locale.getLocale("en", "CA");
        CANADA_FRENCH = Locale.getLocale("fr", "CA");
        ROOT = new Locale("", "", "");
        String language = SystemProperties.getProperty("user.language", "en");
        String country = SystemProperties.getProperty("user.country", "US");
        String region = SystemProperties.getProperty("user.region", null);
        String variant = SystemProperties.getProperty("user.variant", "");
        defaultLocale = Locale.getLocale(language, region != null ? region : country, variant);
    }

    private static Locale getLocale(String language) {
        return Locale.getLocale(language, "", "");
    }

    private static Locale getLocale(String language, String country) {
        return Locale.getLocale(language, country, "");
    }

    private static Locale getLocale(String language, String country, String variant) {
        String name;
        Locale locale;
        if (localeMap == null) {
            localeMap = new HashMap(256);
        }
        if ((locale = (Locale)localeMap.get(name = String.valueOf(language) + "_" + country + "_" + variant)) == null) {
            locale = new Locale(language, country, variant);
            localeMap.put(name, locale);
        }
        return locale;
    }

    private String convertLanguage(String language) {
        if (language.equals("")) {
            return language;
        }
        int index = "he,id,yi".indexOf(language = language.toLowerCase());
        if (index != -1) {
            return "iw,in,ji".substring(index, index + 2);
        }
        return language;
    }

    public Locale(String language, String country, String variant) {
        if (defaultLocale != null) {
            language = this.convertLanguage(language);
            country = country.toUpperCase();
        }
        this.language = language.intern();
        this.country = country.intern();
        this.variant = variant.intern();
        this.hashcode = language.hashCode() ^ country.hashCode() ^ variant.hashCode();
    }

    public Locale(String language, String country) {
        this(language, country, "");
    }

    public Locale(String language) {
        this(language, "", "");
    }

    public static Locale getDefault() {
        return defaultLocale;
    }

    public static void setDefault(Locale newLocale) {
        if (newLocale == null) {
            throw new NullPointerException();
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new PropertyPermission("user.language", "write"));
        }
        defaultLocale = newLocale;
    }

    public static synchronized Locale[] getAvailableLocales() {
        if (availableLocales == null) {
            int len = LocaleHelper.getLocaleCount();
            availableLocales = new Locale[len];
            int i = 0;
            while (i < len) {
                int index;
                String country = "";
                String variant = "";
                String name = LocaleHelper.getLocaleName(i);
                String language = name.substring(0, 2);
                if (name.length() > 2) {
                    country = name.substring(3);
                }
                if ((index = country.indexOf("_")) > 0) {
                    variant = country.substring(index + 1);
                    country = country.substring(0, index - 1);
                }
                Locale.availableLocales[i] = Locale.getLocale(language, country, variant);
                ++i;
            }
        }
        return (Locale[])availableLocales.clone();
    }

    public static String[] getISOCountries() {
        if (countryCache == null) {
            countryCache = Locale.getISOStrings("territories");
        }
        return (String[])countryCache.clone();
    }

    public static String[] getISOLanguages() {
        if (languageCache == null) {
            languageCache = Locale.getISOStrings("languages");
        }
        return (String[])languageCache.clone();
    }

    private static String[] getISOStrings(String tableName) {
        int count = 0;
        ResourceBundle bundle = ResourceBundle.getBundle("gnu.java.locale.LocaleInformation");
        Enumeration<String> e = bundle.getKeys();
        ArrayList<String> tempList = new ArrayList<String>();
        while (e.hasMoreElements()) {
            String str;
            String key = e.nextElement();
            if (!key.startsWith(String.valueOf(tableName) + ".") || (str = key.substring(tableName.length() + 1)).length() != 2 || !Character.isLetter(str.charAt(0)) || !Character.isLetter(str.charAt(1))) continue;
            tempList.add(str);
            ++count;
        }
        String[] strings = new String[count];
        int a = 0;
        while (a < count) {
            strings[a] = (String)tempList.get(a);
            ++a;
        }
        return strings;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getCountry() {
        return this.country;
    }

    public String getVariant() {
        return this.variant;
    }

    public String toString() {
        if (this.language.length() == 0 && this.country.length() == 0) {
            return "";
        }
        if (this.country.length() == 0 && this.variant.length() == 0) {
            return this.language;
        }
        CPStringBuilder result = new CPStringBuilder(this.language);
        result.append('_').append(this.country);
        if (this.variant.length() != 0) {
            result.append('_').append(this.variant);
        }
        return result.toString();
    }

    public String getISO3Language() {
        if (this.language == "") {
            return "";
        }
        int index = "aa,ab,af,am,ar,as,ay,az,ba,be,bg,bh,bi,bn,bo,br,ca,co,cs,cy,da,de,dz,el,en,eo,es,et,eu,fa,fi,fj,fo,fr,fy,ga,gd,gl,gn,gu,ha,iw,hi,hr,hu,hy,ia,in,ie,ik,in,is,it,iu,iw,ja,ji,jw,ka,kk,kl,km,kn,ko,ks,ku,ky,la,ln,lo,lt,lv,mg,mi,mk,ml,mn,mo,mr,ms,mt,my,na,ne,nl,no,oc,om,or,pa,pl,ps,pt,qu,rm,rn,ro,ru,rw,sa,sd,sg,sh,si,sk,sl,sm,sn,so,sq,sr,ss,st,su,sv,sw,ta,te,tg,th,ti,tk,tl,tn,to,tr,ts,tt,tw,ug,uk,ur,uz,vi,vo,wo,xh,ji,yo,za,zh,zu".indexOf(this.language);
        if (index % 3 != 0 || this.language.length() != 2) {
            throw new MissingResourceException("Can't find ISO3 language for " + this.language, "java.util.Locale", this.language);
        }
        return "aarabkaframharaasmaymazebakbelbulbihbisbenbodbrecatcoscescymdandeudzoellengepospaesteusfasfinfijfaofrafrygaigdhglggrngujhauhebhinhrvhunhyeinaindileipkindislitaikuhebjpnyidjawkatkazkalkhmkankorkaskurkirlatlinlaolitlavmlgmrimkdmalmonmolmarmsamltmyanaunepnldnorociormoripanpolpusporquerohrunronruskinsansndsagsrpsinslkslvsmosnasomsqisrpsswsotsunsweswatamteltgkthatirtuktgltsntonturtsotattwiuigukrurduzbvievolwolxhoyidyorzhazhozul".substring(index, index + 3);
    }

    public String getISO3Country() {
        if (this.country == "") {
            return "";
        }
        int index = "AD,AE,AF,AG,AI,AL,AM,AN,AO,AQ,AR,AS,AT,AU,AW,AZ,BA,BB,BD,BE,BF,BG,BH,BI,BJ,BM,BN,BO,BR,BS,BT,BV,BW,BY,BZ,CA,CC,CF,CG,CH,CI,CK,CL,CM,CN,CO,CR,CU,CV,CX,CY,CZ,DE,DJ,DK,DM,DO,DZ,EC,EE,EG,EH,ER,ES,ET,FI,FJ,FK,FM,FO,FR,FX,GA,GB,GD,GE,GF,GH,GI,GL,GM,GN,GP,GQ,GR,GS,GT,GU,GW,GY,HK,HM,HN,HR,HT,HU,ID,IE,IL,IN,IO,IQ,IR,IS,IT,JM,JO,JP,KE,KG,KH,KI,KM,KN,KP,KR,KW,KY,KZ,LA,LB,LC,LI,LK,LR,LS,LT,LU,LV,LY,MA,MC,MD,MG,MH,MK,ML,MM,MN,MO,MP,MQ,MR,MS,MT,MU,MV,MW,MX,MY,MZ,NA,NC,NE,NF,NG,NI,NL,NO,NP,NR,NU,NZ,OM,PA,PE,PF,PG,PH,PK,PL,PM,PN,PR,PT,PW,PY,QA,RE,RO,RU,RW,SA,SB,SC,SD,SE,SG,SH,SI,SJ,SK,SL,SM,SN,SO,SR,ST,SV,SY,SZ,TC,TD,TF,TG,TH,TJ,TK,TM,TN,TO,TP,TR,TT,TV,TW,TZ,UA,UG,UM,US,UY,UZ,VA,VC,VE,VG,VI,VN,VU,WF,WS,YE,YT,YU,ZA,ZM,ZR,ZW".indexOf(this.country);
        if (index % 3 != 0 || this.country.length() != 2) {
            throw new MissingResourceException("Can't find ISO3 country for " + this.country, "java.util.Locale", this.country);
        }
        return "ANDAREAFGATGAIAALBARMANTAGOATAARGASMAUTAUSABWAZEBIHBRBBGDBELBFABGRBHRBDIBENBMUBRNBOLBRABHSBTNBVTBWABLRBLZCANCCKCAFCOGCHECIVCOKCHLCMRCHNCOLCRICUBCPVCXRCYPCZEDEUDJIDNKDMADOMDZAECUESTEGYESHERIESPETHFINFJIFLKFSMFROFRAFXXGABGBRGRDGEOGUFGHAGIBGRLGMBGINGLPGNQGRCSGSGTMGUMGNBGUYHKGHMDHNDHRVHTIHUNIDNIRLISRINDIOTIRQIRNISLITAJAMJORJPNKENKGZKHMKIRCOMKNAPRKKORKWTCYMKAZLAOLBNLCALIELKALBRLSOLTULUXLVALBYMARMCOMDAMDGMHLMKDMLIMMRMNGMACMNPMTQMRTMSRMLTMUSMDVMWIMEXMYSMOZNAMNCLNERNFKNGANICNLDNORNPLNRUNIUNZLOMNPANPERPYFPNGPHLPAKPOLSPMPCNPRIPRTPLWPRYQATREUROMRUSRWASAUSLBSYCSDNSWESGPSHNSVNSJMSVKSLESMRSENSOMSURSTPSLVSYRSWZTCATCDATFTGOTHATJKTKLTKMTUNTONTMPTURTTOTUVTWNTZAUKRUGAUMIUSAURYUZBVATVCTVENVGBVIRVNMVUTWLFWSMYEMMYTYUGZAFZMBZARZWE".substring(index, index + 3);
    }

    public String getDisplayLanguage() {
        return this.getDisplayLanguage(defaultLocale);
    }

    /*
     * Unable to fully structure code
     */
    public String getDisplayLanguage(Locale inLocale) {
        if (this.language.isEmpty()) {
            return "";
        }
        try {
            res = ResourceBundle.getBundle("gnu.java.locale.LocaleInformation", inLocale, ClassLoader.getSystemClassLoader());
            return res.getString("languages." + this.language);
        }
        catch (MissingResourceException v0) {
            ** for (p : ServiceLoader.load(LocaleNameProvider.class))
        }
lbl-1000:
        // 1 sources

        {
            var7_8 = p.getAvailableLocales();
            var6_7 = var7_8.length;
            var5_6 = 0;
            while (var5_6 < var6_7) {
                loc = var7_8[var5_6];
                if (loc.equals(inLocale)) {
                    locLang = p.getDisplayLanguage(this.language, inLocale);
                    if (locLang == null) continue block2;
                    return locLang;
                }
                ++var5_6;
            }
            continue;
        }
lbl20:
        // 1 sources

        if (inLocale.equals(Locale.ROOT)) {
            return this.language;
        }
        return this.getDisplayLanguage(LocaleHelper.getFallbackLocale(inLocale));
    }

    public String getDisplayCountry() {
        return this.getDisplayCountry(defaultLocale);
    }

    /*
     * Unable to fully structure code
     */
    public String getDisplayCountry(Locale inLocale) {
        if (this.country.isEmpty()) {
            return "";
        }
        try {
            res = ResourceBundle.getBundle("gnu.java.locale.LocaleInformation", inLocale, ClassLoader.getSystemClassLoader());
            return res.getString("territories." + this.country);
        }
        catch (MissingResourceException v0) {
            ** for (p : ServiceLoader.load(LocaleNameProvider.class))
        }
lbl-1000:
        // 1 sources

        {
            var7_8 = p.getAvailableLocales();
            var6_7 = var7_8.length;
            var5_6 = 0;
            while (var5_6 < var6_7) {
                loc = var7_8[var5_6];
                if (loc.equals(inLocale)) {
                    locCountry = p.getDisplayCountry(this.country, inLocale);
                    if (locCountry == null) continue block2;
                    return locCountry;
                }
                ++var5_6;
            }
            continue;
        }
lbl20:
        // 1 sources

        if (inLocale.equals(Locale.ROOT)) {
            return this.country;
        }
        return this.getDisplayCountry(LocaleHelper.getFallbackLocale(inLocale));
    }

    public String getDisplayVariant() {
        return this.getDisplayVariant(defaultLocale);
    }

    /*
     * Unable to fully structure code
     */
    public String getDisplayVariant(Locale inLocale) {
        if (this.variant.isEmpty()) {
            return "";
        }
        try {
            res = ResourceBundle.getBundle("gnu.java.locale.LocaleInformation", inLocale, ClassLoader.getSystemClassLoader());
            return res.getString("variants." + this.variant);
        }
        catch (MissingResourceException v0) {
            ** for (p : ServiceLoader.load(LocaleNameProvider.class))
        }
lbl-1000:
        // 1 sources

        {
            var7_8 = p.getAvailableLocales();
            var6_7 = var7_8.length;
            var5_6 = 0;
            while (var5_6 < var6_7) {
                loc = var7_8[var5_6];
                if (loc.equals(inLocale)) {
                    locVar = p.getDisplayVariant(this.variant, inLocale);
                    if (locVar == null) continue block2;
                    return locVar;
                }
                ++var5_6;
            }
            continue;
        }
lbl20:
        // 1 sources

        if (inLocale.equals(Locale.ROOT)) {
            return this.country;
        }
        return this.getDisplayVariant(LocaleHelper.getFallbackLocale(inLocale));
    }

    public String getDisplayName() {
        return this.getDisplayName(defaultLocale);
    }

    public String getDisplayName(Locale locale) {
        CPStringBuilder result = new CPStringBuilder();
        int count = 0;
        String[] delimiters = new String[]{"", " (", ","};
        if (this.language.length() != 0) {
            result.append(delimiters[count++]);
            result.append(this.getDisplayLanguage(locale));
        }
        if (this.country.length() != 0) {
            result.append(delimiters[count++]);
            result.append(this.getDisplayCountry(locale));
        }
        if (this.variant.length() != 0) {
            result.append(delimiters[count++]);
            result.append(this.getDisplayVariant(locale));
        }
        if (count > 1) {
            result.append(")");
        }
        return result.toString();
    }

    public Object clone() {
        return new Locale(this.language, this.country, this.variant);
    }

    public int hashCode() {
        return this.hashcode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Locale)) {
            return false;
        }
        Locale l = (Locale)obj;
        return this.language == l.language && this.country == l.country && this.variant == l.variant;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        ObjectOutputStream.PutField fields = s.putFields();
        fields.put("hashcode", -1);
        s.defaultWriteObject();
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.hashcode = this.language.hashCode() ^ this.country.hashCode() ^ this.variant.hashCode();
    }
}

