/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumMap<K extends Enum<K>, V>
extends AbstractMap<K, V>
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 458661240069192865L;
    V[] store;
    int cardinality;
    Class<K> enumClass;
    transient Set<Map.Entry<K, V>> entries;
    static final Object emptySlot = new Object();

    public EnumMap(Class<K> keyType) {
        this.store = new Object[((Enum[])keyType.getEnumConstants()).length];
        Arrays.fill(this.store, emptySlot);
        this.cardinality = 0;
        this.enumClass = keyType;
    }

    public EnumMap(EnumMap<K, ? extends V> map) {
        this.store = (Object[])map.store.clone();
        this.cardinality = map.cardinality;
        this.enumClass = map.enumClass;
    }

    public EnumMap(Map<K, ? extends V> map) {
        if (map instanceof EnumMap) {
            EnumMap other = (EnumMap)map;
            this.store = (Object[])other.store.clone();
            this.cardinality = other.cardinality;
            this.enumClass = other.enumClass;
        } else {
            for (Enum key : map.keySet()) {
                int o;
                V value = map.get(key);
                if (this.store == null) {
                    this.enumClass = key.getDeclaringClass();
                    this.store = new Object[((Enum[])this.enumClass.getEnumConstants()).length];
                }
                if (this.store[o = key.ordinal()] == emptySlot) {
                    ++this.cardinality;
                }
                this.store[o] = value;
            }
            if (this.store == null) {
                throw new IllegalArgumentException("no elements in map");
            }
        }
    }

    @Override
    public int size() {
        return this.cardinality;
    }

    @Override
    public boolean containsValue(Object value) {
        V[] VArray = this.store;
        int n = this.store.length;
        int n2 = 0;
        while (n2 < n) {
            V i = VArray[n2];
            if (i != emptySlot && AbstractCollection.equals(i, value)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public boolean containsKey(Object key) {
        if (!(key instanceof Enum)) {
            return false;
        }
        Enum e = (Enum)key;
        if (e.getDeclaringClass() != this.enumClass) {
            return false;
        }
        return this.store[e.ordinal()] != emptySlot;
    }

    @Override
    public V get(Object key) {
        if (!(key instanceof Enum)) {
            return null;
        }
        Enum e = (Enum)key;
        if (e.getDeclaringClass() != this.enumClass) {
            return null;
        }
        V o = this.store[e.ordinal()];
        return o == emptySlot ? null : (V)o;
    }

    @Override
    public V put(K key, V value) {
        V result;
        int o = ((Enum)key).ordinal();
        if (this.store[o] == emptySlot) {
            result = null;
            ++this.cardinality;
        } else {
            result = this.store[o];
        }
        this.store[o] = value;
        return result;
    }

    @Override
    public V remove(Object key) {
        if (!(key instanceof Enum)) {
            return null;
        }
        Enum e = (Enum)key;
        if (e.getDeclaringClass() != this.enumClass) {
            return null;
        }
        V result = this.store[e.ordinal()];
        if (result == emptySlot) {
            result = null;
        } else {
            --this.cardinality;
        }
        this.store[e.ordinal()] = emptySlot;
        return result;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        for (Enum key : map.keySet()) {
            V value = map.get(key);
            int o = key.ordinal();
            if (this.store[o] == emptySlot) {
                ++this.cardinality;
            }
            this.store[o] = value;
        }
    }

    @Override
    public void clear() {
        Arrays.fill(this.store, emptySlot);
        this.cardinality = 0;
    }

    @Override
    public Set<K> keySet() {
        if (this.keys == null) {
            this.keys = new AbstractSet<K>(){

                @Override
                public int size() {
                    return EnumMap.this.cardinality;
                }

                @Override
                public Iterator<K> iterator() {
                    return new Iterator<K>(){
                        int count = 0;
                        int index = -1;

                        @Override
                        public boolean hasNext() {
                            return this.count < (this).EnumMap.this.cardinality;
                        }

                        @Override
                        public K next() {
                            ++this.count;
                            ++this.index;
                            while ((this).EnumMap.this.store[this.index] == emptySlot) {
                                ++this.index;
                            }
                            return ((Enum[])(this).EnumMap.this.enumClass.getEnumConstants())[this.index];
                        }

                        @Override
                        public void remove() {
                            --(this).EnumMap.this.cardinality;
                            (this).EnumMap.this.store[this.index] = emptySlot;
                        }
                    };
                }

                @Override
                public void clear() {
                    EnumMap.this.clear();
                }

                @Override
                public boolean contains(Object o) {
                    return this.contains(o);
                }

                @Override
                public boolean remove(Object o) {
                    return EnumMap.this.remove(o) != null;
                }
            };
        }
        return this.keys;
    }

    @Override
    public Collection<V> values() {
        if (this.values == null) {
            this.values = new AbstractCollection<V>(){

                @Override
                public int size() {
                    return EnumMap.this.cardinality;
                }

                @Override
                public Iterator<V> iterator() {
                    return new Iterator<V>(){
                        int count = 0;
                        int index = -1;

                        @Override
                        public boolean hasNext() {
                            return this.count < (this).EnumMap.this.cardinality;
                        }

                        @Override
                        public V next() {
                            ++this.count;
                            ++this.index;
                            while ((this).EnumMap.this.store[this.index] == emptySlot) {
                                ++this.index;
                            }
                            return (this).EnumMap.this.store[this.index];
                        }

                        @Override
                        public void remove() {
                            --(this).EnumMap.this.cardinality;
                            (this).EnumMap.this.store[this.index] = emptySlot;
                        }
                    };
                }

                @Override
                public void clear() {
                    EnumMap.this.clear();
                }
            };
        }
        return this.values;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.entries == null) {
            this.entries = new AbstractSet<Map.Entry<K, V>>(){

                @Override
                public int size() {
                    return EnumMap.this.cardinality;
                }

                @Override
                public Iterator<Map.Entry<K, V>> iterator() {
                    return new Iterator<Map.Entry<K, V>>(){
                        int count = 0;
                        int index = -1;

                        @Override
                        public boolean hasNext() {
                            return this.count < (this).EnumMap.this.cardinality;
                        }

                        @Override
                        public Map.Entry<K, V> next() {
                            ++this.count;
                            ++this.index;
                            while ((this).EnumMap.this.store[this.index] == emptySlot) {
                                ++this.index;
                            }
                            return new AbstractMap.SimpleEntry<K, V>(((Enum[])(this).EnumMap.this.enumClass.getEnumConstants())[this.index], (this).EnumMap.this.store[this.index]){

                                @Override
                                public V setValue(V newVal) {
                                    this.value = newVal;
                                    return EnumMap.this.put((Enum)this.key, newVal);
                                }
                            };
                        }

                        @Override
                        public void remove() {
                            --(this).EnumMap.this.cardinality;
                            (this).EnumMap.this.store[this.index] = emptySlot;
                        }
                    };
                }

                @Override
                public void clear() {
                    EnumMap.this.clear();
                }

                @Override
                public boolean contains(Object o) {
                    if (!(o instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry other = (Map.Entry)o;
                    return EnumMap.this.containsKey(other.getKey()) && AbstractCollection.equals(EnumMap.this.get(other.getKey()), other.getValue());
                }

                @Override
                public boolean remove(Object o) {
                    if (!(o instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry other = (Map.Entry)o;
                    return EnumMap.this.remove(other.getKey()) != null;
                }
            };
        }
        return this.entries;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof EnumMap)) {
            return false;
        }
        EnumMap other = (EnumMap)o;
        if (other.enumClass != this.enumClass || other.cardinality != this.cardinality) {
            return false;
        }
        return Arrays.equals(this.store, other.store);
    }

    @Override
    public EnumMap<K, V> clone() {
        EnumMap result;
        try {
            result = (EnumMap)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            result = null;
        }
        result.store = (Object[])this.store.clone();
        return result;
    }
}

