/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import gnu.java.lang.CPStringBuilder;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.text.DateFormatSymbols;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.TimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Calendar
implements Serializable,
Cloneable,
Comparable<Calendar> {
    public static final int ERA = 0;
    public static final int YEAR = 1;
    public static final int MONTH = 2;
    public static final int WEEK_OF_YEAR = 3;
    public static final int WEEK_OF_MONTH = 4;
    public static final int DATE = 5;
    public static final int DAY_OF_MONTH = 5;
    public static final int DAY_OF_YEAR = 6;
    public static final int DAY_OF_WEEK = 7;
    public static final int DAY_OF_WEEK_IN_MONTH = 8;
    public static final int AM_PM = 9;
    public static final int HOUR = 10;
    public static final int HOUR_OF_DAY = 11;
    public static final int MINUTE = 12;
    public static final int SECOND = 13;
    public static final int MILLISECOND = 14;
    public static final int ZONE_OFFSET = 15;
    public static final int DST_OFFSET = 16;
    public static final int FIELD_COUNT = 17;
    public static final int SUNDAY = 1;
    public static final int MONDAY = 2;
    public static final int TUESDAY = 3;
    public static final int WEDNESDAY = 4;
    public static final int THURSDAY = 5;
    public static final int FRIDAY = 6;
    public static final int SATURDAY = 7;
    public static final int JANUARY = 0;
    public static final int FEBRUARY = 1;
    public static final int MARCH = 2;
    public static final int APRIL = 3;
    public static final int MAY = 4;
    public static final int JUNE = 5;
    public static final int JULY = 6;
    public static final int AUGUST = 7;
    public static final int SEPTEMBER = 8;
    public static final int OCTOBER = 9;
    public static final int NOVEMBER = 10;
    public static final int DECEMBER = 11;
    public static final int UNDECIMBER = 12;
    public static final int AM = 0;
    public static final int PM = 1;
    public static final int ALL_STYLES = 0;
    public static final int SHORT = 1;
    public static final int LONG = 2;
    protected int[] fields = new int[17];
    protected boolean[] isSet = new boolean[17];
    protected long time;
    protected boolean isTimeSet;
    protected boolean areFieldsSet;
    private TimeZone zone;
    private static final String calendarClassName = "java.util.GregorianCalendar";
    private boolean lenient;
    private int firstDayOfWeek;
    private int minimalDaysInFirstWeek;
    private boolean explicitDSTOffset = false;
    private int serialVersionOnStream = 1;
    static final long serialVersionUID = -1807547505821590642L;
    private static final String bundleName = "gnu.java.locale.LocaleInformation";
    private static final transient Properties properties = new Properties();
    private static final HashMap<Locale, Class> cache;
    private static Class[] ctorArgTypes;
    private static final String[] fieldNames;

    static {
        try {
            properties.load(Calendar.class.getResourceAsStream("weeks.properties"));
        }
        catch (IOException exception) {
            System.out.println("Failed to load weeks resource: " + exception);
        }
        cache = new HashMap();
        ctorArgTypes = new Class[]{TimeZone.class, Locale.class};
        fieldNames = new String[]{",ERA=", ",YEAR=", ",MONTH=", ",WEEK_OF_YEAR=", ",WEEK_OF_MONTH=", ",DAY_OF_MONTH=", ",DAY_OF_YEAR=", ",DAY_OF_WEEK=", ",DAY_OF_WEEK_IN_MONTH=", ",AM_PM=", ",HOUR=", ",HOUR_OF_DAY=", ",MINUTE=", ",SECOND=", ",MILLISECOND=", ",ZONE_OFFSET=", ",DST_OFFSET="};
    }

    private static ResourceBundle getBundle(Locale locale) {
        return ResourceBundle.getBundle(bundleName, locale, ClassLoader.getSystemClassLoader());
    }

    protected Calendar() {
        this(TimeZone.getDefault(), Locale.getDefault());
    }

    protected Calendar(TimeZone zone, Locale locale) {
        String first;
        this.zone = zone;
        this.lenient = true;
        String[] days = new String[]{"", "sun", "mon", "tue", "wed", "thu", "fri", "sat"};
        String country = locale.getCountry();
        String min = properties.getProperty("minDays." + country);
        if (min == null) {
            min = properties.getProperty("minDays.DEFAULT");
        }
        if ((first = properties.getProperty("firstDay." + country)) == null) {
            first = properties.getProperty("firstDay.DEFAULT");
        }
        try {
            if (min != null) {
                this.minimalDaysInFirstWeek = Integer.parseInt(min);
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.minimalDaysInFirstWeek = 1;
        }
        this.firstDayOfWeek = 1;
        if (first != null) {
            int i = 0;
            while (i < 8) {
                if (days[i].equals(first)) {
                    this.firstDayOfWeek = i;
                }
                ++i;
            }
        }
        this.clear();
    }

    public static synchronized Calendar getInstance() {
        return Calendar.getInstance(TimeZone.getDefault(), Locale.getDefault());
    }

    public static synchronized Calendar getInstance(TimeZone zone) {
        return Calendar.getInstance(zone, Locale.getDefault());
    }

    public static synchronized Calendar getInstance(Locale locale) {
        return Calendar.getInstance(TimeZone.getDefault(), locale);
    }

    public static synchronized Calendar getInstance(TimeZone zone, Locale locale) {
        Class<?> calendarClass = cache.get(locale);
        Exception exception = null;
        try {
            if (calendarClass == null && Calendar.class.isAssignableFrom(calendarClass = Class.forName(calendarClassName))) {
                cache.put(locale, calendarClass);
            }
            if (calendarClass == GregorianCalendar.class) {
                return new GregorianCalendar(zone, locale);
            }
            if (Calendar.class.isAssignableFrom(calendarClass)) {
                Constructor<?> ctor = calendarClass.getConstructor(ctorArgTypes);
                return (Calendar)ctor.newInstance(zone, locale);
            }
        }
        catch (ClassNotFoundException ex) {
            exception = ex;
        }
        catch (IllegalAccessException ex) {
            exception = ex;
        }
        catch (NoSuchMethodException ex) {
            exception = ex;
        }
        catch (InstantiationException ex) {
            exception = ex;
        }
        catch (InvocationTargetException ex) {
            exception = ex;
        }
        throw new RuntimeException("Error instantiating calendar for locale " + locale, exception);
    }

    public static synchronized Locale[] getAvailableLocales() {
        ResourceBundle rb = Calendar.getBundle(new Locale("", ""));
        return (Locale[])rb.getObject("availableLocales");
    }

    protected abstract void computeTime();

    protected abstract void computeFields();

    public final Date getTime() {
        if (!this.isTimeSet) {
            this.computeTime();
        }
        return new Date(this.time);
    }

    public final void setTime(Date date) {
        this.setTimeInMillis(date.getTime());
    }

    public long getTimeInMillis() {
        if (!this.isTimeSet) {
            this.computeTime();
        }
        return this.time;
    }

    public void setTimeInMillis(long time) {
        this.clear();
        this.time = time;
        this.isTimeSet = true;
        this.computeFields();
    }

    public int get(int field) {
        if (!this.isSet[field]) {
            this.areFieldsSet = false;
        }
        this.complete();
        return this.fields[field];
    }

    protected final int internalGet(int field) {
        return this.fields[field];
    }

    public void set(int field, int value) {
        if (this.isTimeSet) {
            int i = 0;
            while (i < 17) {
                this.isSet[i] = false;
                ++i;
            }
        }
        this.isTimeSet = false;
        this.fields[field] = value;
        this.isSet[field] = true;
        switch (field) {
            case 2: {
                this.isSet[6] = false;
                this.isSet[3] = false;
                break;
            }
            case 5: {
                this.isSet[1] = true;
                this.isSet[2] = true;
                this.isSet[4] = true;
                this.isSet[7] = false;
                this.isSet[8] = false;
                this.isSet[6] = false;
                this.isSet[3] = false;
                break;
            }
            case 4: {
                if (!this.isSet[7]) {
                    this.fields[7] = this.getFirstDayOfWeek();
                }
                this.isSet[1] = true;
                this.isSet[2] = true;
                this.isSet[7] = true;
                this.isSet[5] = false;
                this.isSet[8] = false;
                this.isSet[6] = false;
                this.isSet[3] = false;
                break;
            }
            case 8: {
                if (!this.isSet[7]) {
                    this.fields[7] = this.getFirstDayOfWeek();
                }
                this.isSet[1] = true;
                this.isSet[2] = true;
                this.isSet[7] = true;
                this.isSet[6] = false;
                this.isSet[5] = false;
                this.isSet[4] = false;
                this.isSet[3] = false;
                break;
            }
            case 6: {
                this.isSet[1] = true;
                this.isSet[2] = false;
                this.isSet[4] = false;
                this.isSet[5] = false;
                this.isSet[7] = false;
                this.isSet[3] = false;
                this.isSet[8] = false;
                break;
            }
            case 3: {
                if (!this.isSet[7]) {
                    this.fields[7] = this.getFirstDayOfWeek();
                }
                this.isSet[1] = true;
                this.isSet[7] = true;
                this.isSet[2] = false;
                this.isSet[5] = false;
                this.isSet[4] = false;
                this.isSet[6] = false;
                this.isSet[8] = false;
                break;
            }
            case 9: {
                this.isSet[10] = true;
                this.isSet[11] = false;
                break;
            }
            case 11: {
                this.isSet[9] = false;
                this.isSet[10] = false;
                break;
            }
            case 10: {
                this.isSet[9] = true;
                this.isSet[11] = false;
                break;
            }
            case 16: {
                this.explicitDSTOffset = true;
            }
        }
        if (!this.explicitDSTOffset && field != 16 && field != 15) {
            this.isSet[16] = false;
        }
    }

    public final void set(int year, int month, int date) {
        this.isTimeSet = false;
        this.fields[1] = year;
        this.fields[2] = month;
        this.fields[5] = date;
        this.isSet[5] = true;
        this.isSet[2] = true;
        this.isSet[1] = true;
        this.isSet[3] = false;
        this.isSet[6] = false;
        this.isSet[4] = false;
        this.isSet[7] = false;
        this.isSet[8] = false;
        this.isSet[0] = false;
        if (!this.explicitDSTOffset) {
            this.isSet[16] = false;
        }
    }

    public final void set(int year, int month, int date, int hour, int minute) {
        this.set(year, month, date);
        this.fields[11] = hour;
        this.fields[12] = minute;
        this.isSet[12] = true;
        this.isSet[11] = true;
        this.isSet[9] = false;
        this.isSet[10] = false;
    }

    public final void set(int year, int month, int date, int hour, int minute, int second) {
        this.set(year, month, date, hour, minute);
        this.fields[13] = second;
        this.isSet[13] = true;
    }

    public final void clear() {
        this.isTimeSet = false;
        this.areFieldsSet = false;
        int zoneOffs = this.zone.getRawOffset();
        int[] nArray = new int[17];
        nArray[0] = 1;
        nArray[1] = 1970;
        nArray[3] = 1;
        nArray[4] = 1;
        nArray[5] = 1;
        nArray[6] = 1;
        nArray[7] = 5;
        nArray[8] = 1;
        nArray[15] = zoneOffs;
        int[] tempFields = nArray;
        this.fields = tempFields;
        int i = 0;
        while (i < 17) {
            this.isSet[i] = false;
            ++i;
        }
    }

    public final void clear(int field) {
        int[] nArray = new int[17];
        nArray[0] = 1;
        nArray[1] = 1970;
        nArray[3] = 1;
        nArray[4] = 1;
        nArray[5] = 1;
        nArray[6] = 1;
        nArray[7] = 5;
        nArray[8] = 1;
        nArray[15] = this.zone.getRawOffset();
        int[] tempFields = nArray;
        this.complete();
        this.isTimeSet = false;
        this.areFieldsSet = false;
        this.isSet[field] = false;
        this.fields[field] = tempFields[field];
    }

    public final boolean isSet(int field) {
        return this.isSet[field];
    }

    protected void complete() {
        if (!this.isTimeSet) {
            this.computeTime();
        }
        if (!this.areFieldsSet) {
            this.computeFields();
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof Calendar)) {
            return false;
        }
        Calendar cal = (Calendar)o;
        if (this.getTimeInMillis() == ((Calendar)o).getTimeInMillis() && cal.getFirstDayOfWeek() == this.getFirstDayOfWeek() && cal.isLenient() == this.isLenient() && cal.getMinimalDaysInFirstWeek() == this.getMinimalDaysInFirstWeek()) {
            TimeZone self = this.getTimeZone();
            TimeZone oth = cal.getTimeZone();
            return self == null ? oth == null : self.equals(oth);
        }
        return false;
    }

    public int hashCode() {
        long time = this.getTimeInMillis();
        int val = (int)(time & 0xFFFFFFFFL ^ time >> 32);
        val += this.getFirstDayOfWeek() + (this.isLenient() ? 1230 : 1237) + this.getMinimalDaysInFirstWeek();
        TimeZone self = this.getTimeZone();
        if (self != null) {
            val ^= self.hashCode();
        }
        return val;
    }

    public boolean before(Object o) {
        return this.getTimeInMillis() < ((Calendar)o).getTimeInMillis();
    }

    public boolean after(Object o) {
        return this.getTimeInMillis() > ((Calendar)o).getTimeInMillis();
    }

    public abstract void add(int var1, int var2);

    public abstract void roll(int var1, boolean var2);

    public void roll(int field, int amount) {
        while (amount > 0) {
            this.roll(field, true);
            --amount;
        }
        while (amount < 0) {
            this.roll(field, false);
            ++amount;
        }
    }

    public void setTimeZone(TimeZone zone) {
        this.zone = zone;
        this.computeTime();
        this.computeFields();
    }

    public TimeZone getTimeZone() {
        return this.zone;
    }

    public void setLenient(boolean lenient) {
        this.lenient = lenient;
    }

    public boolean isLenient() {
        return this.lenient;
    }

    public void setFirstDayOfWeek(int value) {
        this.firstDayOfWeek = value;
    }

    public int getFirstDayOfWeek() {
        return this.firstDayOfWeek;
    }

    public void setMinimalDaysInFirstWeek(int value) {
        this.minimalDaysInFirstWeek = value;
    }

    public int getMinimalDaysInFirstWeek() {
        return this.minimalDaysInFirstWeek;
    }

    public abstract int getMinimum(int var1);

    public abstract int getMaximum(int var1);

    public abstract int getGreatestMinimum(int var1);

    public abstract int getLeastMaximum(int var1);

    public int getActualMinimum(int field) {
        Calendar tmp = (Calendar)this.clone();
        int min = tmp.getGreatestMinimum(field);
        int end = tmp.getMinimum(field);
        tmp.set(field, min);
        while (min > end) {
            tmp.add(field, -1);
            if (tmp.get(field) != min - 1) break;
            --min;
        }
        return min;
    }

    public int getActualMaximum(int field) {
        Calendar tmp = (Calendar)this.clone();
        int max = tmp.getLeastMaximum(field);
        int end = tmp.getMaximum(field);
        tmp.set(field, max);
        while (max < end) {
            tmp.add(field, 1);
            if (tmp.get(field) != max + 1) break;
            ++max;
        }
        return max;
    }

    @Override
    public int compareTo(Calendar cal) {
        long t2;
        long t1 = this.getTimeInMillis();
        if (t1 == (t2 = cal.getTimeInMillis())) {
            return 0;
        }
        if (t1 > t2) {
            return 1;
        }
        return -1;
    }

    public Object clone() {
        try {
            Calendar cal = (Calendar)super.clone();
            cal.fields = (int[])this.fields.clone();
            cal.isSet = (boolean[])this.isSet.clone();
            return cal;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public String toString() {
        CPStringBuilder sb = new CPStringBuilder(this.getClass().getName());
        sb.append('[');
        sb.append("time=");
        if (this.isTimeSet) {
            sb.append(this.time);
        } else {
            sb.append("?");
        }
        sb.append(",zone=" + this.zone);
        sb.append(",areFieldsSet=" + this.areFieldsSet);
        int i = 0;
        while (i < 17) {
            sb.append(fieldNames[i]);
            if (this.isSet[i]) {
                sb.append(this.fields[i]);
            } else {
                sb.append("?");
            }
            ++i;
        }
        sb.append(",lenient=").append(this.lenient);
        sb.append(",firstDayOfWeek=").append(this.firstDayOfWeek);
        sb.append(",minimalDaysInFirstWeek=").append(this.minimalDaysInFirstWeek);
        sb.append("]");
        return sb.toString();
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        if (!this.isTimeSet) {
            this.computeTime();
        }
        stream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        if (!this.isTimeSet) {
            this.computeTime();
        }
        if (this.serialVersionOnStream > 1) {
            this.fields = new int[17];
            this.isSet = new boolean[17];
            this.areFieldsSet = false;
        }
    }

    public String getDisplayName(int field, int style, Locale locale) {
        if (field < 0 || field >= 17) {
            throw new IllegalArgumentException("The field value, " + field + ", is invalid.");
        }
        if (style != 1 && style != 2) {
            throw new IllegalArgumentException("The style must be either short or long.");
        }
        if (field == 1 || field == 3 || field == 4 || field == 5 || field == 6 || field == 8 || field == 10 || field == 11 || field == 12 || field == 13 || field == 14) {
            return null;
        }
        int value = this.get(field);
        DateFormatSymbols syms = DateFormatSymbols.getInstance(locale);
        if (field == 0) {
            return syms.getEras()[value];
        }
        if (field == 2) {
            if (style == 2) {
                return syms.getMonths()[value];
            }
            return syms.getShortMonths()[value];
        }
        if (field == 7) {
            if (style == 2) {
                return syms.getWeekdays()[value];
            }
            return syms.getShortWeekdays()[value];
        }
        if (field == 9) {
            return syms.getAmPmStrings()[value];
        }
        if (field == 15) {
            if (style == 2) {
                return syms.getZoneStrings()[value][1];
            }
            return syms.getZoneStrings()[value][2];
        }
        if (field == 16) {
            if (style == 2) {
                return syms.getZoneStrings()[value][3];
            }
            return syms.getZoneStrings()[value][4];
        }
        throw new InternalError("Failed to resolve field " + field + " with style " + style + " for locale " + locale);
    }

    public Map<String, Integer> getDisplayNames(int field, int style, Locale locale) {
        if (field < 0 || field >= 17) {
            throw new IllegalArgumentException("The field value, " + field + ", is invalid.");
        }
        if (style != 1 && style != 2 && style != 0) {
            throw new IllegalArgumentException("The style must be either short, long or all styles.");
        }
        if (field == 1 || field == 3 || field == 4 || field == 5 || field == 6 || field == 8 || field == 10 || field == 11 || field == 12 || field == 13 || field == 14) {
            return null;
        }
        DateFormatSymbols syms = DateFormatSymbols.getInstance(locale);
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        if (field == 0) {
            String[] eras = syms.getEras();
            int a = 0;
            while (a < eras.length) {
                map.put(eras[a], a);
                ++a;
            }
            return map;
        }
        if (field == 2) {
            int a;
            String[] months;
            if (style == 2 || style == 0) {
                months = syms.getMonths();
                a = 0;
                while (a < months.length) {
                    map.put(months[a], a);
                    ++a;
                }
            }
            if (style == 1 || style == 0) {
                months = syms.getShortMonths();
                a = 0;
                while (a < months.length) {
                    map.put(months[a], a);
                    ++a;
                }
            }
            return map;
        }
        if (field == 7) {
            int a;
            String[] weekdays;
            if (style == 2 || style == 0) {
                weekdays = syms.getWeekdays();
                a = 1;
                while (a < weekdays.length) {
                    map.put(weekdays[a], a);
                    ++a;
                }
            }
            if (style == 1 || style == 0) {
                weekdays = syms.getShortWeekdays();
                a = 1;
                while (a < weekdays.length) {
                    map.put(weekdays[a], a);
                    ++a;
                }
            }
            return map;
        }
        if (field == 9) {
            String[] ampms = syms.getAmPmStrings();
            int a = 0;
            while (a < ampms.length) {
                map.put(ampms[a], a);
                ++a;
            }
            return map;
        }
        if (field == 15) {
            String[][] zones = syms.getZoneStrings();
            int a = 0;
            while (a < zones.length) {
                if (style == 2 || style == 0) {
                    map.put(zones[a][1], a);
                }
                if (style == 1 || style == 0) {
                    map.put(zones[a][2], a);
                }
                ++a;
            }
            return map;
        }
        if (field == 16) {
            String[][] zones = syms.getZoneStrings();
            int a = 0;
            while (a < zones.length) {
                if (style == 2 || style == 0) {
                    map.put(zones[a][3], a);
                }
                if (style == 1 || style == 0) {
                    map.put(zones[a][4], a);
                }
                ++a;
            }
            return map;
        }
        throw new InternalError("Failed to resolve field " + field + " with style " + style + " for locale " + locale);
    }
}

