/*
 * Decompiled with CFR 0.152.
 */
package java.rmi.dgc;

import gnu.java.lang.CPStringBuilder;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.server.UID;
import java.util.Arrays;

public final class VMID
implements Serializable {
    static final long serialVersionUID = -538642295484486218L;
    static boolean areWeUnique;
    static byte[] localAddr;
    private byte[] addr = localAddr;
    transient int hash;
    private UID uid = new UID();

    static {
        byte[] byArray = new byte[4];
        byArray[0] = 127;
        byArray[3] = 1;
        byte[] localHost = byArray;
        try {
            localAddr = InetAddress.getLocalHost().getAddress();
            areWeUnique = !Arrays.equals(localHost, localAddr);
        }
        catch (UnknownHostException unknownHostException) {
            localAddr = localHost;
            areWeUnique = false;
        }
    }

    public static boolean isUnique() {
        return areWeUnique;
    }

    public int hashCode() {
        if (this.hash == 0) {
            int i = 0;
            while (i < localAddr.length) {
                this.hash += this.addr[i];
                ++i;
            }
            this.hash ^= this.uid.hashCode();
        }
        return this.hash;
    }

    public boolean equals(Object obj) {
        if (obj instanceof VMID) {
            VMID other = (VMID)obj;
            return this.uid.equals(other.uid) && Arrays.equals(this.addr, other.addr);
        }
        return false;
    }

    public String toString() {
        CPStringBuilder buf = new CPStringBuilder("[VMID: ");
        int i = 0;
        while (i < this.addr.length) {
            if (i > 0) {
                buf.append(".");
            }
            buf.append(Integer.toString(this.addr[i]));
            ++i;
        }
        buf.append(" ");
        buf.append(this.uid.toString());
        buf.append("]");
        return buf.toString();
    }
}

