/*
 * Decompiled with CFR 0.152.
 */
package java.rmi.activation;

import gnu.java.rmi.activation.DefaultActivationGroup;
import gnu.java.rmi.activation.DefaultActivationSystem;
import java.lang.reflect.Constructor;
import java.rmi.MarshalledObject;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.activation.ActivationException;
import java.rmi.activation.ActivationGroupDesc;
import java.rmi.activation.ActivationGroupID;
import java.rmi.activation.ActivationID;
import java.rmi.activation.ActivationInstantiator;
import java.rmi.activation.ActivationMonitor;
import java.rmi.activation.ActivationSystem;
import java.rmi.activation.UnknownGroupException;
import java.rmi.activation.UnknownObjectException;
import java.rmi.server.UnicastRemoteObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ActivationGroup
extends UnicastRemoteObject
implements ActivationInstantiator {
    static final long serialVersionUID = -7696947875314805420L;
    static ActivationGroupID currentGroupId = null;
    final ActivationGroupID groupId;
    ActivationMonitor monitor;
    long incarnation;
    static ActivationSystem system;
    static final Class[] cConstructorTypes;

    static {
        cConstructorTypes = new Class[]{ActivationGroupID.class, MarshalledObject.class};
    }

    protected ActivationGroup(ActivationGroupID aGroupId) throws RemoteException {
        this.groupId = aGroupId;
    }

    public abstract void activeObject(ActivationID var1, Remote var2) throws ActivationException, UnknownObjectException, RemoteException;

    public boolean inactiveObject(ActivationID id) throws ActivationException, UnknownObjectException, RemoteException {
        if (this.monitor != null) {
            this.monitor.inactiveObject(id);
        }
        return true;
    }

    public static ActivationGroup createGroup(ActivationGroupID id, ActivationGroupDesc desc, long incarnation) throws ActivationException {
        Class groupClass;
        if (system == null) {
            system = id.system;
        }
        ActivationGroup group = null;
        if (desc.className != null) {
            try {
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                groupClass = loader.loadClass(desc.className);
            }
            catch (ClassNotFoundException e) {
                ActivationException acex = new ActivationException("Cannot load " + desc.className);
                acex.detail = e;
                throw acex;
            }
        } else {
            groupClass = DefaultActivationGroup.class;
        }
        try {
            Constructor constructor = groupClass.getConstructor(cConstructorTypes);
            group = (ActivationGroup)constructor.newInstance(id, desc.data);
        }
        catch (Exception e) {
            ActivationException acex = new ActivationException("Cannot instantiate " + desc.className);
            acex.detail = e;
            throw acex;
        }
        currentGroupId = id;
        try {
            group.monitor = ActivationGroup.getSystem().activeGroup(id, group, incarnation);
            return group;
        }
        catch (RemoteException e) {
            ActivationException acex = new ActivationException("createGroup");
            acex.detail = e;
            throw acex;
        }
    }

    public static ActivationGroupID currentGroupID() {
        try {
            if (currentGroupId == null) {
                ActivationGroup.setSystem(DefaultActivationSystem.get());
            }
        }
        catch (ActivationException e) {
            InternalError ierr = new InternalError("Unable to activate AS");
            ierr.initCause(e);
            throw ierr;
        }
        return currentGroupId;
    }

    public static void setSystem(ActivationSystem aSystem) throws ActivationException {
        if (currentGroupId != null) {
            throw new ActivationException("Group active");
        }
        try {
            system = aSystem;
            ActivationGroupDesc def = new ActivationGroupDesc(DefaultActivationGroup.class.getName(), "", null, null, null);
            currentGroupId = system.registerGroup(def);
        }
        catch (Exception ex) {
            InternalError ierr = new InternalError("Unable to start default AG");
            ierr.initCause(ex);
            throw ierr;
        }
    }

    public static ActivationSystem getSystem() throws ActivationException {
        if (system == null) {
            system = DefaultActivationSystem.get();
        }
        return system;
    }

    protected void activeObject(ActivationID id, MarshalledObject<? extends Remote> mObject) throws ActivationException, UnknownObjectException, RemoteException {
        if (this.monitor != null) {
            this.monitor.activeObject(id, mObject);
        }
        id.group = this;
    }

    protected void inactiveGroup() throws UnknownGroupException, RemoteException {
        if (this.monitor != null) {
            this.monitor.inactiveGroup(this.groupId, this.incarnation);
        }
        if (currentGroupId != null && currentGroupId.equals(this.groupId)) {
            currentGroupId = null;
        }
    }
}

