/*
 * Decompiled with CFR 0.152.
 */
package java.beans;

import java.beans.FeatureDescriptor;
import java.beans.IntrospectionException;
import java.beans.PropertyEditor;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyDescriptor
extends FeatureDescriptor {
    Class<?> propertyType;
    Method getMethod;
    Method setMethod;
    Class<?> propertyEditorClass;
    boolean bound;
    boolean constrained;

    PropertyDescriptor(String name) {
        this.setName(name);
    }

    public PropertyDescriptor(String name, Class<?> beanClass) throws IntrospectionException {
        this.setName(name);
        if (name.length() == 0) {
            throw new IntrospectionException("empty property name");
        }
        String caps = String.valueOf(Character.toUpperCase(name.charAt(0))) + name.substring(1);
        this.findMethods(beanClass, "is" + caps, "get" + caps, "set" + caps);
        if (this.getMethod == null) {
            throw new IntrospectionException("Cannot find a is" + caps + " or get" + caps + " method");
        }
        if (this.setMethod == null) {
            throw new IntrospectionException("Cannot find a " + caps + " method");
        }
        this.propertyType = this.checkMethods(this.getMethod, this.setMethod);
    }

    public PropertyDescriptor(String name, Class<?> beanClass, String getMethodName, String setMethodName) throws IntrospectionException {
        this.setName(name);
        this.findMethods(beanClass, getMethodName, null, setMethodName);
        if (this.getMethod == null && getMethodName != null) {
            throw new IntrospectionException("Cannot find a getter method called " + getMethodName);
        }
        if (this.setMethod == null && setMethodName != null) {
            throw new IntrospectionException("Cannot find a setter method called " + setMethodName);
        }
        this.propertyType = this.checkMethods(this.getMethod, this.setMethod);
    }

    public PropertyDescriptor(String name, Method readMethod, Method writeMethod) throws IntrospectionException {
        this.setName(name);
        this.getMethod = readMethod;
        this.setMethod = writeMethod;
        this.propertyType = this.checkMethods(this.getMethod, this.setMethod);
    }

    public Class<?> getPropertyType() {
        return this.propertyType;
    }

    public Method getReadMethod() {
        return this.getMethod;
    }

    public void setReadMethod(Method readMethod) throws IntrospectionException {
        this.propertyType = this.checkMethods(readMethod, this.setMethod);
        this.getMethod = readMethod;
    }

    public Method getWriteMethod() {
        return this.setMethod;
    }

    public void setWriteMethod(Method writeMethod) throws IntrospectionException {
        this.propertyType = this.checkMethods(this.getMethod, writeMethod);
        this.setMethod = writeMethod;
    }

    public boolean isBound() {
        return this.bound;
    }

    public void setBound(boolean bound) {
        this.bound = bound;
    }

    public boolean isConstrained() {
        return this.constrained;
    }

    public void setConstrained(boolean constrained) {
        this.constrained = constrained;
    }

    public Class<?> getPropertyEditorClass() {
        return this.propertyEditorClass;
    }

    public void setPropertyEditorClass(Class<?> propertyEditorClass) {
        this.propertyEditorClass = propertyEditorClass;
    }

    public PropertyEditor createPropertyEditor(Object bean) {
        if (this.propertyEditorClass == null) {
            return null;
        }
        Constructor c = this.findConstructor(this.propertyEditorClass, new Class[]{Object.class});
        if (c != null) {
            return this.instantiateClass(c, new Object[]{bean});
        }
        c = this.findConstructor(this.propertyEditorClass, null);
        if (c != null) {
            return this.instantiateClass(c, null);
        }
        return null;
    }

    private Constructor findConstructor(Class k, Class[] argTypes) {
        try {
            return k.getConstructor(argTypes);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    private PropertyEditor instantiateClass(Constructor c, Object[] args) {
        try {
            return (PropertyEditor)c.newInstance(args);
        }
        catch (InstantiationException instantiationException) {
            return null;
        }
        catch (InvocationTargetException invocationTargetException) {
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    private void findMethods(Class beanClass, String getMethodName1, String getMethodName2, String setMethodName) throws IntrospectionException {
        block14: {
            try {
                if (getMethodName1 != null) {
                    try {
                        this.getMethod = beanClass.getMethod(getMethodName1, new Class[0]);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {}
                }
                if (this.getMethod == null && getMethodName2 != null) {
                    try {
                        this.getMethod = beanClass.getMethod(getMethodName2, new Class[0]);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {}
                }
                if (setMethodName == null) break block14;
                if (this.getMethod != null) {
                    Class<?> propertyType = this.getMethod.getReturnType();
                    if (propertyType == Void.TYPE) {
                        String msg = "The property's read method has return type 'void'";
                        throw new IntrospectionException(msg);
                    }
                    Class[] setArgs = new Class[]{propertyType};
                    try {
                        this.setMethod = beanClass.getMethod(setMethodName, setArgs);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {}
                    break block14;
                }
                if (getMethodName1 != null || getMethodName2 != null) break block14;
                Method[] methods = beanClass.getMethods();
                int i = 0;
                while (i < methods.length) {
                    if (methods[i].getName().equals(setMethodName) && methods[i].getParameterTypes().length == 1 && methods[i].getReturnType() == Void.TYPE) {
                        this.setMethod = methods[i];
                        break;
                    }
                    ++i;
                }
            }
            catch (SecurityException securityException) {
                String msg = "SecurityException thrown on attempt to access methods.";
                throw new IntrospectionException(msg);
            }
        }
    }

    private Class<?> checkMethods(Method readMethod, Method writeMethod) throws IntrospectionException {
        Class<?> newPropertyType = this.propertyType;
        if (readMethod != null) {
            if (readMethod.getParameterTypes().length > 0) {
                throw new IntrospectionException("read method has unexpected parameters");
            }
            newPropertyType = readMethod.getReturnType();
            if (newPropertyType == Void.TYPE) {
                throw new IntrospectionException("read method return type is void");
            }
        }
        if (writeMethod != null) {
            if (writeMethod.getParameterTypes().length != 1) {
                String msg = "write method does not have exactly one parameter";
                throw new IntrospectionException(msg);
            }
            if (readMethod == null) {
                newPropertyType = writeMethod.getParameterTypes()[0];
            } else if (newPropertyType != null && !newPropertyType.isAssignableFrom(writeMethod.getParameterTypes()[0])) {
                throw new IntrospectionException("read and write method are not compatible");
            }
        }
        return newPropertyType;
    }

    public int hashCode() {
        return (this.propertyType == null ? 0 : this.propertyType.hashCode()) | (this.propertyEditorClass == null ? 0 : this.propertyEditorClass.hashCode()) | (this.bound ? Boolean.TRUE : Boolean.FALSE).hashCode() | (this.constrained ? Boolean.TRUE : Boolean.FALSE).hashCode() | (this.getMethod == null ? 0 : this.getMethod.hashCode()) | (this.setMethod == null ? 0 : this.setMethod.hashCode());
    }

    public boolean equals(Object o) {
        if (o instanceof PropertyDescriptor) {
            boolean sameWriteMethod;
            boolean sameReadMethod;
            boolean sameFlags;
            boolean samePropertyType;
            PropertyDescriptor that = (PropertyDescriptor)o;
            boolean bl = this.propertyType == null ? that.propertyType == null : (samePropertyType = this.propertyType.equals(that.propertyType));
            boolean samePropertyEditorClass = this.propertyEditorClass == null ? that.propertyEditorClass == null : this.propertyEditorClass.equals(that.propertyEditorClass);
            boolean bl2 = sameFlags = this.bound == that.bound && this.constrained == that.constrained;
            boolean bl3 = this.getMethod == null ? that.getMethod == null : (sameReadMethod = this.getMethod.equals(that.getMethod));
            boolean bl4 = this.setMethod == null ? that.setMethod == null : (sameWriteMethod = this.setMethod.equals(that.setMethod));
            return samePropertyType && sameFlags && sameReadMethod && sameWriteMethod && samePropertyEditorClass;
        }
        return false;
    }
}

