/*
 * Decompiled with CFR 0.152.
 */
package java.awt.color;

import gnu.java.awt.color.CieXyzConverter;
import gnu.java.awt.color.ClutProfileConverter;
import gnu.java.awt.color.ColorSpaceConverter;
import gnu.java.awt.color.GrayProfileConverter;
import gnu.java.awt.color.GrayScaleConverter;
import gnu.java.awt.color.LinearRGBConverter;
import gnu.java.awt.color.PyccConverter;
import gnu.java.awt.color.RgbProfileConverter;
import gnu.java.awt.color.SrgbConverter;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.color.ICC_ProfileGray;
import java.awt.color.ICC_ProfileRGB;
import java.io.IOException;
import java.io.ObjectInputStream;

public class ICC_ColorSpace
extends ColorSpace {
    private static final long serialVersionUID = 3455889114070431483L;
    private ICC_Profile thisProfile;
    private float[] minVal;
    private float[] maxVal;
    private float[] diffMinMax;
    private float[] invDiffMinMax;
    private boolean needScaleInit;
    private transient int type;
    private transient int nComponents;
    private transient ColorSpaceConverter converter;

    public ICC_ColorSpace(ICC_Profile profile) {
        super(profile.getColorSpaceType(), profile.getNumComponents());
        this.converter = this.getConverter(profile);
        this.thisProfile = profile;
        this.nComponents = profile.getNumComponents();
        this.type = profile.getColorSpaceType();
        this.makeArrays();
    }

    public ICC_Profile getProfile() {
        return this.thisProfile;
    }

    public float[] toRGB(float[] colorvalue) {
        return this.converter.toRGB(colorvalue);
    }

    public float[] fromRGB(float[] rgbvalue) {
        return this.converter.fromRGB(rgbvalue);
    }

    public float[] toCIEXYZ(float[] colorvalue) {
        return this.converter.toCIEXYZ(colorvalue);
    }

    public float[] fromCIEXYZ(float[] colorvalue) {
        return this.converter.fromCIEXYZ(colorvalue);
    }

    public boolean isCS_sRGB() {
        return this.converter instanceof SrgbConverter;
    }

    public float getMinValue(int idx) {
        if (this.type == 1 && (idx == 1 || idx == 2)) {
            return -128.0f;
        }
        if (idx < 0 || idx >= this.nComponents) {
            throw new IllegalArgumentException();
        }
        return 0.0f;
    }

    public float getMaxValue(int idx) {
        if (this.type == 0 && idx >= 0 && idx <= 2) {
            return 1.9999695f;
        }
        if (this.type == 1) {
            if (idx == 0) {
                return 100.0f;
            }
            if (idx == 1 || idx == 2) {
                return 127.0f;
            }
        }
        if (idx < 0 || idx >= this.nComponents) {
            throw new IllegalArgumentException();
        }
        return 1.0f;
    }

    private ColorSpaceConverter getConverter(ICC_Profile profile) {
        ColorSpaceConverter converter;
        switch (profile.isPredefined()) {
            case 1000: {
                converter = new SrgbConverter();
                break;
            }
            case 1001: {
                converter = new CieXyzConverter();
                break;
            }
            case 1003: {
                converter = new GrayScaleConverter();
                break;
            }
            case 1004: {
                converter = new LinearRGBConverter();
                break;
            }
            case 1002: {
                converter = new PyccConverter();
                break;
            }
            default: {
                converter = profile instanceof ICC_ProfileRGB ? new RgbProfileConverter((ICC_ProfileRGB)profile) : (profile instanceof ICC_ProfileGray ? new GrayProfileConverter((ICC_ProfileGray)profile) : new ClutProfileConverter(profile));
            }
        }
        return converter;
    }

    private void makeArrays() {
        this.minVal = new float[this.nComponents];
        this.maxVal = new float[this.nComponents];
        this.diffMinMax = null;
        this.invDiffMinMax = null;
        int i = 0;
        while (i < this.nComponents) {
            this.minVal[i] = this.getMinValue(i);
            this.maxVal[i] = this.getMaxValue(i);
            ++i;
        }
        this.needScaleInit = true;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.converter = this.getConverter(this.thisProfile);
        this.nComponents = this.thisProfile.getNumComponents();
        this.type = this.thisProfile.getColorSpaceType();
    }
}

