/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.validation.datatype;

import gnu.xml.validation.datatype.AtomicSimpleType;
import gnu.xml.validation.datatype.TypeLibrary;
import java.math.BigInteger;
import javax.xml.namespace.QName;
import org.relaxng.datatype.DatatypeException;
import org.relaxng.datatype.ValidationContext;

final class NonPositiveIntegerType
extends AtomicSimpleType {
    static final int[] CONSTRAINING_FACETS = new int[]{11, 12, 4, 6, 5, 7, 8, 10, 9};

    NonPositiveIntegerType() {
        super(new QName("http://www.w3.org/2001/XMLSchema", "nonPositiveInteger"), TypeLibrary.INTEGER);
    }

    public int[] getConstrainingFacets() {
        return CONSTRAINING_FACETS;
    }

    public void checkValid(String value, ValidationContext context) throws DatatypeException {
        super.checkValid(value, context);
        int len = value.length();
        if (len == 0) {
            throw new DatatypeException(0, "invalid non-positive integer value");
        }
        boolean positive = true;
        int i = 0;
        while (i < len) {
            char c = value.charAt(i);
            if (c != '0') {
                if (c >= '1' && c <= '9') {
                    if (positive) {
                        throw new DatatypeException(i, "invalid non-positive integer value");
                    }
                } else if (c != '+' || i != 0) {
                    if (c == '-' && i == 0) {
                        positive = false;
                    } else {
                        throw new DatatypeException(i, "invalid non-positive integer value");
                    }
                }
            }
            ++i;
        }
    }

    public Object createValue(String literal, ValidationContext context) {
        try {
            return new BigInteger(literal);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }
}

