/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.dom;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSException;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSParser;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

class DomDocumentBuilder
extends DocumentBuilder {
    final DOMImplementation impl;
    final DOMImplementationLS ls;
    final LSParser parser;

    DomDocumentBuilder(DOMImplementation impl, DOMImplementationLS ls, LSParser parser) {
        this.impl = impl;
        this.ls = ls;
        this.parser = parser;
    }

    public boolean isNamespaceAware() {
        DOMConfiguration config = this.parser.getDomConfig();
        return (Boolean)config.getParameter("namespaces");
    }

    public boolean isValidating() {
        DOMConfiguration config = this.parser.getDomConfig();
        return (Boolean)config.getParameter("validating");
    }

    public boolean isXIncludeAware() {
        DOMConfiguration config = this.parser.getDomConfig();
        return (Boolean)config.getParameter("xinclude-aware");
    }

    public void setEntityResolver(EntityResolver resolver) {
        DOMConfiguration config = this.parser.getDomConfig();
        config.setParameter("entity-resolver", resolver);
    }

    public void setErrorHandler(ErrorHandler handler) {
        DOMConfiguration config = this.parser.getDomConfig();
        config.setParameter("error-handler", handler);
    }

    public DOMImplementation getDOMImplementation() {
        return this.impl;
    }

    public Document newDocument() {
        return this.impl.createDocument(null, null, null);
    }

    public Document parse(InputStream in) throws SAXException, IOException {
        LSInput input = this.ls.createLSInput();
        input.setByteStream(in);
        try {
            return this.parser.parse(input);
        }
        catch (LSException e) {
            Throwable e2 = e.getCause();
            if (e2 instanceof IOException) {
                throw (IOException)e2;
            }
            throw e;
        }
    }

    public Document parse(InputStream in, String systemId) throws SAXException, IOException {
        LSInput input = this.ls.createLSInput();
        input.setByteStream(in);
        input.setSystemId(systemId);
        try {
            return this.parser.parse(input);
        }
        catch (LSException e) {
            Throwable e2 = e.getCause();
            if (e2 instanceof IOException) {
                throw (IOException)e2;
            }
            throw e;
        }
    }

    public Document parse(String systemId) throws SAXException, IOException {
        try {
            return this.parser.parseURI(systemId);
        }
        catch (LSException e) {
            Throwable e2 = e.getCause();
            if (e2 instanceof IOException) {
                throw (IOException)e2;
            }
            throw e;
        }
    }

    public Document parse(InputSource is) throws SAXException, IOException {
        LSInput input = this.ls.createLSInput();
        String systemId = is.getSystemId();
        InputStream in = is.getByteStream();
        if (in != null) {
            input.setByteStream(in);
        } else {
            Reader reader = is.getCharacterStream();
            if (reader != null) {
                input.setCharacterStream(reader);
            } else {
                try {
                    URL url = new URL(systemId);
                    input.setByteStream(url.openStream());
                }
                catch (MalformedURLException malformedURLException) {
                    File cwd = new File(System.getProperty("user.dir"));
                    URL url = new URL(cwd.toURL(), systemId);
                    input.setByteStream(url.openStream());
                }
            }
        }
        input.setPublicId(is.getPublicId());
        input.setSystemId(systemId);
        input.setEncoding(is.getEncoding());
        try {
            return this.parser.parse(input);
        }
        catch (LSException e) {
            Throwable e2 = e.getCause();
            if (e2 instanceof IOException) {
                throw (IOException)e2;
            }
            throw e;
        }
    }
}

