/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.java.security.action.GetSecurityPropertyAction;
import gnu.javax.net.ssl.AbstractSessionContext;
import gnu.javax.net.ssl.NullManagerParameters;
import gnu.javax.net.ssl.PreSharedKeyManager;
import gnu.javax.net.ssl.SRPTrustManager;
import gnu.javax.net.ssl.provider.SSLEngineImpl;
import gnu.javax.net.ssl.provider.SSLServerSocketFactoryImpl;
import gnu.javax.net.ssl.provider.SSLSocketFactoryImpl;
import java.security.AccessController;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContextSpi;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509TrustManager;

public final class SSLContextImpl
extends SSLContextSpi {
    AbstractSessionContext serverContext;
    AbstractSessionContext clientContext;
    PreSharedKeyManager pskManager;
    X509ExtendedKeyManager keyManager;
    X509TrustManager trustManager;
    SRPTrustManager srpTrustManager;
    SecureRandom random;

    protected SSLEngine engineCreateSSLEngine() {
        return this.engineCreateSSLEngine(null, -1);
    }

    protected SSLEngine engineCreateSSLEngine(String host, int port) {
        return new SSLEngineImpl(this, host, port);
    }

    protected synchronized SSLSessionContext engineGetClientSessionContext() {
        if (this.clientContext == null) {
            try {
                this.clientContext = AbstractSessionContext.newInstance();
            }
            catch (SSLException sSLException) {}
        }
        return this.clientContext;
    }

    protected synchronized SSLSessionContext engineGetServerSessionContext() {
        if (this.serverContext == null) {
            try {
                this.serverContext = AbstractSessionContext.newInstance();
            }
            catch (SSLException sSLException) {}
        }
        return this.serverContext;
    }

    protected SSLServerSocketFactory engineGetServerSocketFactory() {
        return new SSLServerSocketFactoryImpl(this);
    }

    protected SSLSocketFactory engineGetSocketFactory() {
        return new SSLSocketFactoryImpl(this);
    }

    protected void engineInit(KeyManager[] keyManagers, TrustManager[] trustManagers, SecureRandom random) throws KeyManagementException {
        int i;
        this.keyManager = null;
        this.trustManager = null;
        this.srpTrustManager = null;
        if (keyManagers != null) {
            i = 0;
            while (i < keyManagers.length) {
                if (keyManagers[i] instanceof X509ExtendedKeyManager && this.keyManager == null) {
                    this.keyManager = (X509ExtendedKeyManager)keyManagers[i];
                }
                if (keyManagers[i] instanceof PreSharedKeyManager && this.pskManager == null) {
                    this.pskManager = (PreSharedKeyManager)keyManagers[i];
                }
                ++i;
            }
        }
        if (this.keyManager == null) {
            this.keyManager = this.defaultKeyManager();
        }
        if (trustManagers != null) {
            i = 0;
            while (i < trustManagers.length) {
                if (trustManagers[i] instanceof X509TrustManager) {
                    if (this.trustManager == null) {
                        this.trustManager = (X509TrustManager)trustManagers[i];
                    }
                } else if (trustManagers[i] instanceof SRPTrustManager && this.srpTrustManager == null) {
                    this.srpTrustManager = (SRPTrustManager)trustManagers[i];
                }
                ++i;
            }
        }
        if (this.trustManager == null && this.srpTrustManager == null) {
            this.trustManager = this.defaultTrustManager();
        }
        this.random = random != null ? random : this.defaultRandom();
    }

    private X509ExtendedKeyManager defaultKeyManager() throws KeyManagementException {
        KeyManagerFactory fact = null;
        try {
            fact = KeyManagerFactory.getInstance("JessieX509", "Jessie");
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new KeyManagementException(nsae);
        }
        catch (NoSuchProviderException nspe) {
            throw new KeyManagementException(nspe);
        }
        try {
            fact.init(null, null);
            return (X509ExtendedKeyManager)fact.getKeyManagers()[0];
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
        }
        catch (KeyStoreException keyStoreException) {
        }
        catch (UnrecoverableKeyException unrecoverableKeyException) {
        }
        catch (IllegalStateException illegalStateException) {}
        try {
            fact.init(new NullManagerParameters());
            return (X509ExtendedKeyManager)fact.getKeyManagers()[0];
        }
        catch (Exception shouldNotHappen) {
            throw new Error(shouldNotHappen.toString());
        }
    }

    private X509TrustManager defaultTrustManager() throws KeyManagementException {
        try {
            TrustManagerFactory fact = TrustManagerFactory.getInstance("JessieX509", "Jessie");
            fact.init((KeyStore)null);
            return (X509TrustManager)fact.getTrustManagers()[0];
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new KeyManagementException(nsae);
        }
        catch (NoSuchProviderException nspe) {
            throw new KeyManagementException(nspe);
        }
        catch (KeyStoreException kse) {
            throw new KeyManagementException(kse);
        }
    }

    private SecureRandom defaultRandom() {
        GetSecurityPropertyAction gspa = new GetSecurityPropertyAction("gnu.javax.net.ssl.secureRandom");
        String alg = AccessController.doPrivileged(gspa);
        if (alg == null) {
            alg = "Fortuna";
        }
        SecureRandom rand = null;
        try {
            rand = SecureRandom.getInstance(alg);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            rand = new SecureRandom();
        }
        return rand;
    }
}

