/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.javax.net.ssl.provider.Builder;
import gnu.javax.net.ssl.provider.ExchangeKeys;
import gnu.javax.net.ssl.provider.Util;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.math.BigInteger;
import java.nio.ByteBuffer;

public class ClientDiffieHellmanPublic
extends ExchangeKeys
implements Builder {
    public ClientDiffieHellmanPublic(ByteBuffer buffer) {
        super(buffer);
    }

    public ClientDiffieHellmanPublic(BigInteger Yc) {
        super(ClientDiffieHellmanPublic.wrap(Yc));
    }

    private static ByteBuffer wrap(BigInteger Yc) {
        byte[] b = Util.trim(Yc);
        ByteBuffer ret = ByteBuffer.allocate(b.length + 2);
        ret.putShort((short)b.length);
        ret.put(b);
        return (ByteBuffer)ret.rewind();
    }

    public ByteBuffer buffer() {
        return (ByteBuffer)this.buffer.duplicate().rewind().limit(this.length());
    }

    public BigInteger publicValue() {
        int len = this.length() - 2;
        byte[] b = new byte[len];
        this.buffer.position(2);
        this.buffer.get(b);
        this.buffer.rewind();
        return new BigInteger(1, b);
    }

    public void setPublicValue(BigInteger Yc) {
        byte[] buf = Util.trim(Yc);
        if (this.buffer.capacity() < buf.length + 2) {
            this.buffer = ByteBuffer.allocate(buf.length + 2);
        }
        this.buffer.putShort((short)buf.length);
        this.buffer.put(buf);
        this.buffer.rewind();
    }

    public int length() {
        return (this.buffer.getShort(0) & 0xFFFF) + 2;
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(String prefix) {
        StringWriter str = new StringWriter();
        PrintWriter out = new PrintWriter(str);
        if (prefix != null) {
            out.print(prefix);
        }
        out.println("struct {");
        if (prefix != null) {
            out.print(prefix);
        }
        out.print("  dh_Yc = ");
        out.print(this.publicValue().toString(16));
        out.println(';');
        if (prefix != null) {
            out.print(prefix);
        }
        out.print("} ClientDiffieHellmanPublic;");
        return str.toString();
    }
}

