/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl;

import gnu.java.security.Engine;
import gnu.javax.net.ssl.SSLProtocolVersion;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;

public abstract class SSLCipherSuite {
    private static final String SERVICE = "SSLCipherSuite";
    private final String algorithm;
    private final byte[] id;
    private final SSLProtocolVersion version;
    private Provider provider;

    protected SSLCipherSuite(String algorithm, byte[] id, SSLProtocolVersion version) {
        this.algorithm = algorithm;
        if (id.length != 2) {
            throw new IllegalArgumentException("cipher suite ID must be two bytes");
        }
        this.id = (byte[])id.clone();
        this.version = version;
    }

    public static final SSLCipherSuite getInstance(SSLProtocolVersion version, byte[] id) throws NoSuchAlgorithmException {
        return SSLCipherSuite.getInstance((Object)((Object)version) + "-" + (id[0] & 0xFF) + "/" + (id[1] & 0xFF));
    }

    public static final SSLCipherSuite getInstance(SSLProtocolVersion version, byte[] id, Provider provider) throws NoSuchAlgorithmException {
        return SSLCipherSuite.getInstance((Object)((Object)version) + "-" + (id[0] & 0xFF) + "/" + (id[1] & 0xFF), provider);
    }

    public static final SSLCipherSuite getInstance(String name) throws NoSuchAlgorithmException {
        Provider[] providers = Security.getProviders();
        int i = 0;
        while (i < providers.length) {
            try {
                return SSLCipherSuite.getInstance(name, providers[i]);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                ++i;
            }
        }
        throw new NoSuchAlgorithmException("SSLCipherSuite: " + name);
    }

    public static final SSLCipherSuite getInstance(String name, Provider provider) throws NoSuchAlgorithmException {
        SSLCipherSuite suite = null;
        try {
            suite = (SSLCipherSuite)Engine.getInstance(SERVICE, name, provider);
            suite.provider = provider;
        }
        catch (InvocationTargetException ite) {
            NoSuchAlgorithmException nsae = new NoSuchAlgorithmException(name);
            nsae.initCause(ite);
            throw nsae;
        }
        return suite;
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    public final byte[] getId() {
        return (byte[])this.id.clone();
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final SSLProtocolVersion getProtocolVersion() {
        return this.version;
    }

    public abstract void encipher(ByteBuffer var1, ByteBuffer var2);
}

