/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security;

import gnu.classpath.debug.Component;
import gnu.classpath.debug.SystemLogger;
import gnu.java.lang.CPStringBuilder;
import gnu.java.security.action.GetPropertyAction;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.Security;
import java.security.UnresolvedPermission;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class PolicyFile
extends Policy {
    protected static final Logger logger = SystemLogger.SYSTEM;
    private static GetPropertyAction prop = new GetPropertyAction("file.separator");
    private static final String fs = AccessController.doPrivileged(prop);
    private static final String DEFAULT_POLICY = String.valueOf(AccessController.doPrivileged(prop.setParameters("java.home"))) + fs + "lib" + fs + "security" + fs + "java.policy";
    private static final String DEFAULT_USER_POLICY = String.valueOf(AccessController.doPrivileged(prop.setParameters("user.home"))) + fs + ".java.policy";
    private final Map cs2pc = new HashMap();
    private static final int STATE_BEGIN = 0;
    private static final int STATE_GRANT = 1;
    private static final int STATE_PERMS = 2;

    public PolicyFile() {
        this.refresh();
    }

    public PermissionCollection getPermissions(CodeSource codeSource) {
        Permissions perms = new Permissions();
        for (Map.Entry e : this.cs2pc.entrySet()) {
            CodeSource cs = (CodeSource)e.getKey();
            if (cs.implies(codeSource)) {
                logger.log((Level)Component.POLICY, "{0} -> {1}", new Object[]{cs, codeSource});
                PermissionCollection pc = (PermissionCollection)e.getValue();
                Enumeration<Permission> ee = pc.elements();
                while (ee.hasMoreElements()) {
                    perms.add(ee.nextElement());
                }
                continue;
            }
            logger.log((Level)Component.POLICY, "{0} !-> {1}", new Object[]{cs, codeSource});
        }
        logger.log((Level)Component.POLICY, "returning permissions {0} for {1}", new Object[]{perms, codeSource});
        return perms;
    }

    public void refresh() {
        this.cs2pc.clear();
        final LinkedList policyFiles = new LinkedList();
        try {
            policyFiles.add(new File(DEFAULT_POLICY).toURL());
            policyFiles.add(new File(DEFAULT_USER_POLICY).toURL());
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    String allow = Security.getProperty("policy.allowSystemProperty");
                    if (allow == null || Boolean.getBoolean(allow)) {
                        String s = System.getProperty("java.security.policy");
                        logger.log((Level)Component.POLICY, "java.security.policy={0}", s);
                        if (s != null) {
                            boolean only = s.startsWith("=");
                            if (only) {
                                s = s.substring(1);
                            }
                            policyFiles.clear();
                            policyFiles.add(new URL(s));
                            if (only) {
                                return null;
                            }
                        }
                    }
                    int i = 1;
                    while (true) {
                        String pname = "policy.url." + i;
                        String s = Security.getProperty(pname);
                        logger.log((Level)Component.POLICY, "{0}={1}", new Object[]{pname, s});
                        if (s == null) break;
                        policyFiles.add(new URL(s));
                        ++i;
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            logger.log((Level)Component.POLICY, "reading policy properties", pae);
        }
        catch (MalformedURLException mue) {
            logger.log((Level)Component.POLICY, "setting default policies", mue);
        }
        logger.log((Level)Component.POLICY, "building policy from URLs {0}", policyFiles);
        Iterator it = policyFiles.iterator();
        while (it.hasNext()) {
            try {
                URL url = (URL)it.next();
                this.parse(url);
            }
            catch (IOException ioe) {
                logger.log((Level)Component.POLICY, "reading policy", ioe);
            }
        }
    }

    public String toString() {
        return String.valueOf(super.toString()) + " [ " + this.cs2pc.toString() + " ]";
    }

    /*
     * Unable to fully structure code
     */
    private void parse(URL url) throws IOException {
        PolicyFile.logger.log((Level)Component.POLICY, "reading policy file from {0}", url);
        in = new StreamTokenizer(new InputStreamReader(url.openStream()));
        in.resetSyntax();
        in.slashSlashComments(true);
        in.slashStarComments(true);
        in.wordChars(65, 90);
        in.wordChars(97, 122);
        in.wordChars(48, 57);
        in.wordChars(46, 46);
        in.wordChars(95, 95);
        in.wordChars(36, 36);
        in.whitespaceChars(32, 32);
        in.whitespaceChars(9, 9);
        in.whitespaceChars(12, 12);
        in.whitespaceChars(10, 10);
        in.whitespaceChars(13, 13);
        in.quoteChar(39);
        in.quoteChar(34);
        state = 0;
        keystores = new LinkedList<T>();
        currentBase = null;
        currentCerts = new LinkedList<Certificate>();
        currentPerms = new Permissions();
        block26: while ((tok = in.nextToken()) != -1) {
            switch (tok) {
                case 123: {
                    if (state != 1) {
                        PolicyFile.error(url, in, "spurious '{'");
                    }
                    state = 2;
                    tok = in.nextToken();
                    ** GOTO lbl49
                }
                case 125: {
                    if (state != 2) {
                        PolicyFile.error(url, in, "spurious '}'");
                    }
                    state = 0;
                    currentPerms.setReadOnly();
                    c = null;
                    if (!currentCerts.isEmpty()) {
                        c = currentCerts.toArray((T[])new Certificate[currentCerts.size()]);
                    }
                    this.cs2pc.put(new CodeSource(currentBase, c), currentPerms);
                    currentCerts.clear();
                    currentPerms = new Permissions();
                    currentBase = null;
                    tok = in.nextToken();
                    if (tok == 59) continue block26;
                    in.pushBack();
                    break;
                }
lbl49:
                // 2 sources

                default: {
                    if (tok != -3) {
                        PolicyFile.error(url, in, "expecting word token");
                    }
                    if (in.sval.equalsIgnoreCase("keystore")) {
                        alg = KeyStore.getDefaultType();
                        tok = in.nextToken();
                        if (tok != 34 && tok != 39) {
                            PolicyFile.error(url, in, "expecting key store URL");
                        }
                        store = in.sval;
                        tok = in.nextToken();
                        if (tok == 44) {
                            tok = in.nextToken();
                            if (tok != 34 && tok != 39) {
                                PolicyFile.error(url, in, "expecting key store type");
                            }
                            alg = in.sval;
                            tok = in.nextToken();
                        }
                        if (tok != 59) {
                            PolicyFile.error(url, in, "expecting semicolon");
                        }
                        try {
                            keystore = KeyStore.getInstance(alg);
                            keystore.load(new URL(url, store).openStream(), null);
                            keystores.add(keystore);
                        }
                        catch (Exception x) {
                            PolicyFile.error(url, in, x.toString());
                        }
                        continue block26;
                    }
                    if (in.sval.equalsIgnoreCase("grant")) {
                        if (state != 0) {
                            PolicyFile.error(url, in, "extraneous grant keyword");
                        }
                        state = 1;
                        break;
                    }
                    if (in.sval.equalsIgnoreCase("signedBy")) {
                        if (state != 1 && state != 2) {
                            PolicyFile.error(url, in, "spurious 'signedBy'");
                        }
                        if (keystores.isEmpty()) {
                            PolicyFile.error(url, in, "'signedBy' with no keystores");
                        }
                        if ((tok = in.nextToken()) != 34 && tok != 39) {
                            PolicyFile.error(url, in, "expecting signedBy name");
                        }
                        st = new StringTokenizer(in.sval, ",");
                        while (st.hasMoreTokens()) {
                            alias = st.nextToken();
                            for (KeyStore keystore : keystores) {
                                try {
                                    if (!keystore.isCertificateEntry(alias)) continue;
                                    currentCerts.add(keystore.getCertificate(alias));
                                }
                                catch (KeyStoreException kse) {
                                    PolicyFile.error(url, in, kse.toString());
                                }
                            }
                        }
                        tok = in.nextToken();
                        if (tok == 44) continue block26;
                        if (state != 1) {
                            PolicyFile.error(url, in, "spurious ','");
                        }
                        in.pushBack();
                        break;
                    }
                    if (in.sval.equalsIgnoreCase("codeBase")) {
                        if (state != 1) {
                            PolicyFile.error(url, in, "spurious 'codeBase'");
                        }
                        if ((tok = in.nextToken()) != 34 && tok != 39) {
                            PolicyFile.error(url, in, "expecting code base URL");
                        }
                        base = PolicyFile.expand(in.sval);
                        if (File.separatorChar != '/') {
                            base = base.replace(File.separatorChar, '/');
                        }
                        try {
                            currentBase = new URL(base);
                        }
                        catch (MalformedURLException mue) {
                            PolicyFile.error(url, in, mue.toString());
                        }
                        tok = in.nextToken();
                        if (tok == 44) continue block26;
                        in.pushBack();
                        break;
                    }
                    if (in.sval.equalsIgnoreCase("principal")) {
                        if (state != 1) {
                            PolicyFile.error(url, in, "spurious 'principal'");
                        }
                        if ((tok = in.nextToken()) == -3) {
                            tok = in.nextToken();
                            if (tok != 34 && tok != 39) {
                                PolicyFile.error(url, in, "expecting principal name");
                            }
                            name = in.sval;
                            p = null;
                            try {
                                pclass = Class.forName(in.sval);
                                c = pclass.getConstructor(new Class[]{String.class});
                                p = (Principal)c.newInstance(new Object[]{name});
                            }
                            catch (Exception x) {
                                PolicyFile.error(url, in, x.toString());
                            }
                            for (KeyStore ks : keystores) {
                                try {
                                    e = ks.aliases();
                                    while (e.hasMoreElements()) {
                                        alias = e.nextElement();
                                        if (!ks.isCertificateEntry(alias) || !((cert = ks.getCertificate(alias)) instanceof X509Certificate) || !p.equals(((X509Certificate)cert).getSubjectDN()) && !p.equals(((X509Certificate)cert).getSubjectX500Principal())) continue;
                                        currentCerts.add(cert);
                                    }
                                }
                                catch (KeyStoreException kse) {
                                    PolicyFile.error(url, in, kse.toString());
                                }
                            }
                        } else if (tok == 34 || tok == 39) {
                            alias = in.sval;
                            for (KeyStore ks : keystores) {
                                try {
                                    if (!ks.isCertificateEntry(alias)) continue;
                                    currentCerts.add(ks.getCertificate(alias));
                                }
                                catch (KeyStoreException kse) {
                                    PolicyFile.error(url, in, kse.toString());
                                }
                            }
                        } else {
                            PolicyFile.error(url, in, "expecting principal");
                        }
                        tok = in.nextToken();
                        if (tok == 44) continue block26;
                        in.pushBack();
                        break;
                    }
                    if (!in.sval.equalsIgnoreCase("permission")) continue block26;
                    if (state != 2) {
                        PolicyFile.error(url, in, "spurious 'permission'");
                    }
                    if ((tok = in.nextToken()) != -3) {
                        PolicyFile.error(url, in, "expecting permission class name");
                    }
                    className = in.sval;
                    clazz = null;
                    try {
                        clazz = Class.forName(className);
                    }
                    catch (ClassNotFoundException v0) {}
                    tok = in.nextToken();
                    if (tok == 59) {
                        if (clazz == null) {
                            currentPerms.add(new UnresolvedPermission(className, null, null, currentCerts.toArray((T[])new Certificate[currentCerts.size()])));
                            break;
                        }
                        try {
                            currentPerms.add((Permission)clazz.newInstance());
                        }
                        catch (Exception x) {
                            PolicyFile.error(url, in, x.toString());
                        }
                        continue block26;
                    }
                    if (tok != 34 && tok != 39) {
                        PolicyFile.error(url, in, "expecting permission target");
                    }
                    target = PolicyFile.expand(in.sval);
                    tok = in.nextToken();
                    if (tok == 59) {
                        if (clazz == null) {
                            currentPerms.add(new UnresolvedPermission(className, target, null, currentCerts.toArray((T[])new Certificate[currentCerts.size()])));
                            break;
                        }
                        try {
                            c = clazz.getConstructor(new Class[]{String.class});
                            currentPerms.add((Permission)c.newInstance(new Object[]{target}));
                        }
                        catch (Exception x) {
                            PolicyFile.error(url, in, x.toString());
                        }
                        continue block26;
                    }
                    if (tok != 44) {
                        PolicyFile.error(url, in, "expecting ','");
                    }
                    if ((tok = in.nextToken()) == -3) {
                        if (!in.sval.equalsIgnoreCase("signedBy")) {
                            PolicyFile.error(url, in, "expecting 'signedBy'");
                        }
                        try {
                            c = clazz.getConstructor(new Class[]{String.class});
                            currentPerms.add((Permission)c.newInstance(new Object[]{target}));
                        }
                        catch (Exception x) {
                            PolicyFile.error(url, in, x.toString());
                        }
                        in.pushBack();
                        break;
                    }
                    if (tok != 34 && tok != 39) {
                        PolicyFile.error(url, in, "expecting permission action");
                    }
                    action = in.sval;
                    if (clazz == null) {
                        currentPerms.add(new UnresolvedPermission(className, target, action, currentCerts.toArray((T[])new Certificate[currentCerts.size()])));
                        break;
                    }
                    try {
                        c = clazz.getConstructor(new Class[]{String.class, String.class});
                        currentPerms.add((Permission)c.newInstance(new Object[]{target, action}));
                    }
                    catch (Exception x) {
                        PolicyFile.error(url, in, x.toString());
                    }
                    tok = in.nextToken();
                    if (tok == 59 || tok == 44) continue block26;
                    PolicyFile.error(url, in, "expecting ';' or ','");
                }
            }
        }
    }

    private static String expand(String s) {
        CPStringBuilder result = new CPStringBuilder();
        CPStringBuilder prop = new CPStringBuilder();
        int state = 0;
        int i = 0;
        while (i < s.length()) {
            switch (state) {
                case 0: {
                    if (s.charAt(i) == '$') {
                        state = 1;
                        break;
                    }
                    result.append(s.charAt(i));
                    break;
                }
                case 1: {
                    if (s.charAt(i) == '{') {
                        state = 2;
                        break;
                    }
                    state = 0;
                    result.append('$').append(s.charAt(i));
                    break;
                }
                case 2: {
                    if (s.charAt(i) == '}') {
                        String p = prop.toString();
                        if (p.equals("/")) {
                            p = "file.separator";
                        }
                        if ((p = System.getProperty(p)) == null) {
                            p = "";
                        }
                        result.append(p);
                        prop.setLength(0);
                        state = 0;
                        break;
                    }
                    prop.append(s.charAt(i));
                }
            }
            ++i;
        }
        if (state != 0) {
            result.append('$').append('{').append(prop);
        }
        return result.toString();
    }

    private static void error(URL base, StreamTokenizer in, String msg) throws IOException {
        throw new IOException(base + ":" + in.lineno() + ": " + msg);
    }
}

