/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.rmi.server;

import gnu.classpath.VMStackWalker;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.net.MalformedURLException;
import java.rmi.server.RMIClassLoader;

public class RMIObjectInputStream
extends ObjectInputStream {
    public RMIObjectInputStream(InputStream strm) throws IOException {
        super(strm);
        this.enableResolveObject(true);
    }

    protected Class resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
        try {
            return RMIClassLoader.loadClass((String)this.getAnnotation(), desc.getName(), VMStackWalker.firstNonNullClassLoader());
        }
        catch (MalformedURLException x) {
            throw new ClassNotFoundException(desc.getName(), x);
        }
    }

    protected Object getAnnotation() throws IOException, ClassNotFoundException {
        return this.readObject();
    }

    protected Class resolveProxyClass(String[] intfs) throws IOException, ClassNotFoundException {
        try {
            return RMIClassLoader.loadProxyClass((String)this.getAnnotation(), intfs, VMStackWalker.firstNonNullClassLoader());
        }
        catch (MalformedURLException x) {
            throw new ClassNotFoundException(null, x);
        }
    }

    protected Object readValue(Class valueClass) throws IOException, ClassNotFoundException {
        if (valueClass.isPrimitive()) {
            if (valueClass == Boolean.TYPE) {
                return this.readBoolean();
            }
            if (valueClass == Byte.TYPE) {
                return new Byte(this.readByte());
            }
            if (valueClass == Character.TYPE) {
                return new Character(this.readChar());
            }
            if (valueClass == Short.TYPE) {
                return new Short(this.readShort());
            }
            if (valueClass == Integer.TYPE) {
                return new Integer(this.readInt());
            }
            if (valueClass == Long.TYPE) {
                return new Long(this.readLong());
            }
            if (valueClass == Float.TYPE) {
                return new Float(this.readFloat());
            }
            if (valueClass == Double.TYPE) {
                return new Double(this.readDouble());
            }
            throw new Error("Unsupported primitive class: " + valueClass);
        }
        return this.readObject();
    }
}

