/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.nio.charset;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CoderResult;

public abstract class ByteDecodeLoopHelper {
    protected abstract boolean isMappable(byte var1);

    protected abstract char mapToChar(byte var1);

    CoderResult decodeLoop(ByteBuffer in, CharBuffer out) {
        if (in.hasArray() && out.hasArray()) {
            return this.arrayDecodeLoop(in, out);
        }
        return this.normalDecodeLoop(in, out);
    }

    private CoderResult normalDecodeLoop(ByteBuffer in, CharBuffer out) {
        int outRemaining = out.remaining();
        int inRemaining = in.remaining();
        while (inRemaining > 0 && outRemaining > 0) {
            byte b = in.get();
            --inRemaining;
            if (!this.isMappable(b)) {
                in.position(in.position() - 1);
                return CoderResult.unmappableForLength(1);
            }
            char c = this.mapToChar(b);
            out.put(c);
            --outRemaining;
        }
        if (inRemaining > 0) {
            return CoderResult.OVERFLOW;
        }
        return CoderResult.UNDERFLOW;
    }

    private CoderResult arrayDecodeLoop(ByteBuffer in, CharBuffer out) {
        CoderResult result;
        int outPos;
        int inPos;
        block6: {
            int outRemaining;
            byte[] inArray = in.array();
            char[] outArray = out.array();
            inPos = in.arrayOffset() + in.position();
            outPos = out.arrayOffset() + out.position();
            int inRemaining = in.remaining();
            if (inRemaining <= (outRemaining = out.remaining())) {
                int i = 0;
                while (i < inRemaining) {
                    char c;
                    byte b = inArray[inPos];
                    ++inPos;
                    if (!this.isMappable(b)) {
                        --inPos;
                        result = CoderResult.unmappableForLength(1);
                        break block6;
                    }
                    outArray[outPos] = c = this.mapToChar(b);
                    ++outPos;
                    ++i;
                }
                result = CoderResult.UNDERFLOW;
            } else {
                int i = 0;
                while (i < outRemaining) {
                    char c;
                    byte b = inArray[inPos];
                    ++inPos;
                    if (!this.isMappable(b)) {
                        --inPos;
                        result = CoderResult.unmappableForLength(1);
                        break block6;
                    }
                    outArray[outPos] = c = this.mapToChar(b);
                    ++outPos;
                    ++i;
                }
                result = CoderResult.OVERFLOW;
            }
        }
        in.position(inPos - in.arrayOffset());
        out.position(outPos - out.arrayOffset());
        return result;
    }
}

