/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.net.protocol.http;

import gnu.classpath.SystemProperties;
import gnu.java.lang.CPStringBuilder;
import gnu.java.net.EmptyX509TrustManager;
import gnu.java.net.protocol.http.Cookie;
import gnu.java.net.protocol.http.CookieManager;
import gnu.java.net.protocol.http.Request;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

public class HTTPConnection {
    public static final int HTTP_PORT = 80;
    public static final int HTTPS_PORT = 443;
    private static final String userAgent = SystemProperties.getProperty("http.agent");
    protected final String hostname;
    protected final int port;
    protected final boolean secure;
    protected final int connectionTimeout;
    protected final int timeout;
    protected String proxyHostname;
    protected int proxyPort;
    protected int majorVersion;
    protected int minorVersion;
    private final List<HandshakeCompletedListener> handshakeCompletedListeners;
    protected Socket socket;
    private SSLSocketFactory sslSocketFactory;
    protected InputStream in;
    protected OutputStream out;
    private Map<String, Integer> nonceCounts;
    protected CookieManager cookieManager;
    private Pool pool;
    int useCount;
    long timeLastUsed;

    public HTTPConnection(String hostname) {
        this(hostname, 80, false, 0, 0);
    }

    public HTTPConnection(String hostname, boolean secure) {
        this(hostname, secure ? 443 : 80, secure, 0, 0);
    }

    public HTTPConnection(String hostname, boolean secure, int connectionTimeout, int timeout) {
        this(hostname, secure ? 443 : 80, secure, connectionTimeout, timeout);
    }

    public HTTPConnection(String hostname, int port) {
        this(hostname, port, false, 0, 0);
    }

    public HTTPConnection(String hostname, int port, boolean secure) {
        this(hostname, port, secure, 0, 0);
    }

    public HTTPConnection(String hostname, int port, boolean secure, int connectionTimeout, int timeout) {
        if (connectionTimeout < 0 || timeout < 0) {
            throw new IllegalArgumentException();
        }
        this.hostname = hostname;
        this.port = port;
        this.secure = secure;
        this.connectionTimeout = connectionTimeout;
        this.timeout = timeout;
        this.minorVersion = 1;
        this.majorVersion = 1;
        this.handshakeCompletedListeners = new ArrayList<HandshakeCompletedListener>(2);
    }

    public String getHostName() {
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public String getVersion() {
        return "HTTP/" + this.majorVersion + '.' + this.minorVersion;
    }

    public void setVersion(int majorVersion, int minorVersion) {
        if (majorVersion != 1) {
            throw new IllegalArgumentException("major version not supported: " + majorVersion);
        }
        if (minorVersion < 0 || minorVersion > 1) {
            throw new IllegalArgumentException("minor version not supported: " + minorVersion);
        }
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
    }

    public void setProxy(String hostname, int port) {
        this.proxyHostname = hostname;
        this.proxyPort = port;
    }

    public boolean isUsingProxy() {
        return this.proxyHostname != null && this.proxyPort > 0;
    }

    public void setCookieManager(CookieManager cookieManager) {
        this.cookieManager = cookieManager;
    }

    public CookieManager getCookieManager() {
        return this.cookieManager;
    }

    void setPool(Pool p) {
        this.pool = p;
    }

    void release() {
        if (this.pool != null) {
            ++this.useCount;
            this.pool.put(this);
        } else {
            try {
                this.closeConnection();
            }
            catch (IOException iOException) {}
        }
    }

    public Request newRequest(String method, String path) {
        Cookie[] cookies;
        if (method == null || method.length() == 0) {
            throw new IllegalArgumentException("method must have non-zero length");
        }
        if (path == null || path.length() == 0) {
            path = "/";
        }
        Request ret = new Request(this, method, path);
        if (this.secure && this.port != 443 || !this.secure && this.port != 80) {
            ret.setHeader("Host", String.valueOf(this.hostname) + ":" + this.port);
        } else {
            ret.setHeader("Host", this.hostname);
        }
        ret.setHeader("User-Agent", userAgent);
        ret.setHeader("Connection", "keep-alive");
        ret.setHeader("Accept-Encoding", "chunked;q=1.0, gzip;q=0.9, deflate;q=0.8, identity;q=0.6, *;q=0");
        if (this.cookieManager != null && (cookies = this.cookieManager.getCookies(this.hostname, this.secure, path)) != null && cookies.length > 0) {
            CPStringBuilder buf = new CPStringBuilder();
            buf.append("$Version=1");
            int i = 0;
            while (i < cookies.length) {
                buf.append(',');
                buf.append(' ');
                buf.append(cookies[i].toString());
                ++i;
            }
            ret.setHeader("Cookie", buf.toString());
        }
        return ret;
    }

    public void close() throws IOException {
        this.closeConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized Socket getSocket() throws IOException {
        if (this.socket == null) {
            String connectHostname = this.hostname;
            int connectPort = this.port;
            if (this.isUsingProxy()) {
                connectHostname = this.proxyHostname;
                connectPort = this.proxyPort;
            }
            this.socket = new Socket();
            InetSocketAddress address = new InetSocketAddress(connectHostname, connectPort);
            if (this.connectionTimeout > 0) {
                this.socket.connect(address, this.connectionTimeout);
            } else {
                this.socket.connect(address);
            }
            if (this.timeout > 0) {
                this.socket.setSoTimeout(this.timeout);
            }
            if (this.secure) {
                try {
                    SSLSocketFactory factory = this.getSSLSocketFactory();
                    SSLSocket ss = (SSLSocket)factory.createSocket(this.socket, connectHostname, connectPort, true);
                    String[] protocols = new String[]{"TLSv1", "SSLv3"};
                    ss.setEnabledProtocols(protocols);
                    ss.setUseClientMode(true);
                    List<HandshakeCompletedListener> list2 = this.handshakeCompletedListeners;
                    synchronized (list2) {
                        if (!this.handshakeCompletedListeners.isEmpty()) {
                            for (HandshakeCompletedListener l : this.handshakeCompletedListeners) {
                                ss.addHandshakeCompletedListener(l);
                            }
                        }
                    }
                    ss.startHandshake();
                    this.socket = ss;
                }
                catch (GeneralSecurityException e) {
                    throw new IOException(e.getMessage());
                }
            }
            this.in = this.socket.getInputStream();
            this.in = new BufferedInputStream(this.in);
            this.out = this.socket.getOutputStream();
            this.out = new BufferedOutputStream(this.out);
        }
        return this.socket;
    }

    SSLSocketFactory getSSLSocketFactory() throws GeneralSecurityException {
        if (this.sslSocketFactory == null) {
            EmptyX509TrustManager tm = new EmptyX509TrustManager();
            SSLContext context = SSLContext.getInstance("SSL");
            TrustManager[] trust = new TrustManager[]{tm};
            context.init(null, trust, null);
            this.sslSocketFactory = context.getSocketFactory();
        }
        return this.sslSocketFactory;
    }

    void setSSLSocketFactory(SSLSocketFactory factory) {
        this.sslSocketFactory = factory;
    }

    protected synchronized InputStream getInputStream() throws IOException {
        if (this.socket == null) {
            this.getSocket();
        }
        return this.in;
    }

    protected synchronized OutputStream getOutputStream() throws IOException {
        if (this.socket == null) {
            this.getSocket();
        }
        return this.out;
    }

    protected synchronized void closeConnection() throws IOException {
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            finally {
                this.socket = null;
            }
        }
    }

    protected String getURI() {
        CPStringBuilder buf = new CPStringBuilder();
        buf.append(this.secure ? "https://" : "http://");
        buf.append(this.hostname);
        if (this.secure) {
            if (this.port != 443) {
                buf.append(':');
                buf.append(this.port);
            }
        } else if (this.port != 80) {
            buf.append(':');
            buf.append(this.port);
        }
        return buf.toString();
    }

    int getNonceCount(String nonce) {
        if (this.nonceCounts == null) {
            return 0;
        }
        return this.nonceCounts.get(nonce);
    }

    void incrementNonce(String nonce) {
        int current = this.getNonceCount(nonce);
        if (this.nonceCounts == null) {
            this.nonceCounts = new HashMap<String, Integer>();
        }
        this.nonceCounts.put(nonce, new Integer(current + 1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addHandshakeCompletedListener(HandshakeCompletedListener l) {
        List<HandshakeCompletedListener> list2 = this.handshakeCompletedListeners;
        synchronized (list2) {
            this.handshakeCompletedListeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeHandshakeCompletedListener(HandshakeCompletedListener l) {
        List<HandshakeCompletedListener> list2 = this.handshakeCompletedListeners;
        synchronized (list2) {
            this.handshakeCompletedListeners.remove(l);
        }
    }

    static class Pool {
        static Pool instance = new Pool();
        final LinkedList<HTTPConnection> connectionPool = new LinkedList();
        int maxConnections;
        int connectionTTL;
        Reaper reaper;

        private Pool() {
        }

        private static boolean matches(HTTPConnection c, String h, int p, boolean sec) {
            return h.equals(c.hostname) && p == c.port && sec == c.secure;
        }

        synchronized HTTPConnection get(String host, int port, boolean secure, int connectionTimeout, int timeout) {
            String ttl = SystemProperties.getProperty("classpath.net.http.keepAliveTTL");
            this.connectionTTL = 10000;
            if (ttl != null && ttl.length() > 0) {
                try {
                    int v = 1000 * Integer.parseInt(ttl);
                    if (v >= 0) {
                        this.connectionTTL = v;
                    }
                }
                catch (NumberFormatException numberFormatException) {}
            }
            String mc = SystemProperties.getProperty("http.maxConnections");
            this.maxConnections = 5;
            if (mc != null && mc.length() > 0) {
                try {
                    int v = Integer.parseInt(mc);
                    if (v > 0) {
                        this.maxConnections = v;
                    }
                }
                catch (NumberFormatException numberFormatException) {}
            }
            HTTPConnection c = null;
            ListIterator<HTTPConnection> it = this.connectionPool.listIterator(0);
            while (it.hasNext()) {
                HTTPConnection cc = it.next();
                if (!Pool.matches(cc, host, port, secure)) continue;
                c = cc;
                it.remove();
                if (c.socket == null) break;
                try {
                    c.socket.setSoTimeout(timeout);
                }
                catch (SocketException socketException) {}
                break;
            }
            if (c == null) {
                c = new HTTPConnection(host, port, secure, connectionTimeout, timeout);
                c.setPool(this);
            }
            return c;
        }

        synchronized void put(HTTPConnection c) {
            c.timeLastUsed = System.currentTimeMillis();
            this.connectionPool.addLast(c);
            while (this.connectionPool.size() >= this.maxConnections) {
                this.removeOldest();
            }
            if (this.connectionTTL > 0 && this.reaper == null) {
                this.reaper = new Reaper();
                Thread t = new Thread(this.reaper, "HTTPConnection.Reaper");
                t.setDaemon(true);
                t.start();
            }
        }

        void removeOldest() {
            HTTPConnection cx = this.connectionPool.removeFirst();
            try {
                cx.closeConnection();
            }
            catch (IOException iOException) {}
        }

        class Reaper
        implements Runnable {
            Reaper() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                var1_1 = Pool.this;
                synchronized (var1_1) {
                    try {
                        while (true) {
                            block13: {
                                if (Pool.this.connectionPool.size() > 0) break block13;
                                try {}
                                catch (InterruptedException v0) {}
                                ** GOTO lbl-1000
                            }
                            currentTime = System.currentTimeMillis();
                            c = Pool.this.connectionPool.getFirst();
                            waitTime = c.timeLastUsed + (long)Pool.this.connectionTTL - currentTime;
                            if (waitTime <= 0L) {
                                Pool.this.removeOldest();
                                continue;
                            }
                            try {
                                Pool.this.wait(waitTime);
                            }
                            catch (InterruptedException v1) {}
                            continue;
lbl-1000:
                            // 1 sources

                            {
                                Pool.this.wait(Pool.this.connectionTTL);
                            }
                            if (Pool.this.connectionPool.size() <= 0) break;
                        }
                    }
                    finally {
                        Pool.this.reaper = null;
                    }
                    return;
                }
            }
        }
    }
}

