/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.print;

import gnu.java.awt.print.SpooledDocument;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.awt.image.PixelGrabber;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.text.AttributedCharacterIterator;
import java.util.Map;

class PostScriptGraphics2D
extends Graphics2D {
    private PrinterJob printerJob;
    private PrintWriter out;
    private AffineTransform currentTransform = new AffineTransform();
    private AffineTransform pageTransform;
    private RenderingHints renderingHints;
    private Paint currentPaint = null;
    private Shape clipShape = null;
    private Font currentFont = null;
    private Color currentColor = Color.black;
    private Color backgroundColor = Color.white;
    private Stroke currentStroke = null;
    private static Stroke ordinaryStroke = new BasicStroke(0.0f, 0, 0);
    private float cx;
    private float cy;
    private boolean currentFontIsPS;
    private double pageX = 595.0;
    private double pageY;
    private double Y = this.pageY = 842.0;
    private boolean gradientOn = false;

    public PostScriptGraphics2D(PrinterJob pg) {
        this.printerJob = pg;
        this.pageTransform = new AffineTransform();
        this.currentTransform = new AffineTransform();
        this.renderingHints = new RenderingHints(null);
        this.renderingHints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        this.renderingHints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        this.renderingHints.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        this.renderingHints.put(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        this.renderingHints.put(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
    }

    public SpooledDocument spoolPostScript(Printable printable, PageFormat pageFormat, Pageable pageable) throws PrinterException {
        try {
            File temp = File.createTempFile("cpspool", ".ps");
            temp.deleteOnExit();
            this.out = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(temp), "ISO8859_1"), 1000000));
            this.writePSHeader();
            if (pageable != null) {
                int index = 0;
                while (index < pageable.getNumberOfPages()) {
                    this.spoolPage(this.out, pageable.getPrintable(index), pageable.getPageFormat(index), index);
                    ++index;
                }
            } else {
                int index = 0;
                while (this.spoolPage(this.out, printable, pageFormat, index++) == 0) {
                }
            }
            this.out.println("%%Trailer");
            this.out.println("%%EOF");
            this.out.close();
            return new SpooledDocument(temp);
        }
        catch (IOException e) {
            PrinterException pe = new PrinterException();
            pe.initCause(e);
            throw pe;
        }
    }

    private void writePSHeader() {
        this.out.println("%!PS-Adobe-3.0");
        this.out.println("%%Title: " + this.printerJob.getJobName());
        this.out.println("%%Creator: GNU Classpath ");
        this.out.println("%%DocumentData: Clean8Bit");
        this.out.println("%%DocumentNeededResources: font Times-Roman Helvetica Courier");
        this.out.println("%%EndComments");
        this.out.println("%%BeginProlog");
        this.out.println("%%EndProlog");
        this.out.println("%%BeginSetup");
        this.out.println("%%EndFeature");
        this.setupFonts();
        this.out.println("%%EndSetup");
        this.setFont(new Font("Dialog", 0, 12));
        this.currentColor = Color.white;
        this.currentStroke = new BasicStroke();
        this.setPaint(this.currentColor);
        this.setStroke(this.currentStroke);
    }

    private void setupFonts() {
        this.out.println("/helveticaISO");
        this.out.println("/Helvetica findfont dup length dict begin");
        this.out.println("{ 1 index /FID eq { pop pop } { def } ifelse } forall");
        this.out.println("/Encoding ISOLatin1Encoding def");
        this.out.println("currentdict end definefont pop");
        this.out.println("/timesISO");
        this.out.println("/Times-Roman findfont dup length dict begin");
        this.out.println("{ 1 index /FID eq { pop pop } { def } ifelse } forall");
        this.out.println("/Encoding ISOLatin1Encoding def");
        this.out.println("currentdict end definefont pop");
        this.out.println("/courierISO");
        this.out.println("/Courier findfont dup length dict begin");
        this.out.println("{ 1 index /FID eq { pop pop } { def } ifelse } forall");
        this.out.println("/Encoding ISOLatin1Encoding def");
        this.out.println("currentdict end definefont pop");
    }

    public int spoolPage(PrintWriter out, Printable printable, PageFormat pageFormat, int index) throws IOException, PrinterException {
        out.println("%%BeginPageSetup");
        Paper p = pageFormat.getPaper();
        this.pageX = p.getWidth();
        this.pageY = p.getHeight();
        if (pageFormat.getOrientation() == 1) {
            out.println("%%Orientation: Portrait");
        } else {
            out.println("%%Orientation: Landscape");
            double t = this.pageX;
            this.pageX = this.pageY;
            this.pageY = t;
        }
        this.setClip(0, 0, (int)this.pageX, (int)this.pageY);
        out.println("gsave % first save");
        out.println("<< /PageSize [" + this.pageX + " " + this.pageY + "] >> setpagedevice");
        if (pageFormat.getOrientation() != 0) {
            this.pageTransform.translate(this.pageX, 0.0);
            this.pageTransform.scale(-1.0, 1.0);
        }
        this.pushCTM();
        this.concatCTM(this.pageTransform);
        this.setTransform(new AffineTransform());
        out.println("%%EndPageSetup");
        out.println("gsave");
        if (printable.print(this, pageFormat, index) == 1) {
            return 1;
        }
        out.println("grestore");
        out.println("showpage");
        return 0;
    }

    private void pushCTM() {
        this.out.println("matrix currentmatrix   % pushCTM()");
    }

    private void popCTM() {
        this.out.println("setmatrix % restore CTM");
    }

    public Graphics create() {
        return null;
    }

    public void drawOval(int x, int y, int width, int height) {
        this.out.println("% drawOval()");
        this.setStroke(ordinaryStroke);
        this.draw(new Ellipse2D.Double(x, y, width, height));
        this.setStroke(this.currentStroke);
    }

    public void drawPolyline(int[] xPoints, int[] yPoints, int nPoints) {
        if (nPoints <= 0 || xPoints.length < nPoints || yPoints.length < nPoints) {
            return;
        }
        this.out.println("newpath % drawPolyLine()");
        this.out.println(String.valueOf(xPoints[0]) + " " + yPoints[0] + " moveto");
        int i = 1;
        while (i < nPoints) {
            this.out.println(String.valueOf(xPoints[i]) + " " + yPoints[i] + " lineto");
            ++i;
        }
        this.out.println("closepath");
        this.out.println("stroke");
    }

    public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.out.println("% drawRoundRect()");
        RoundRectangle2D.Double rr = new RoundRectangle2D.Double(x, y, width, height, arcWidth, arcHeight);
        this.setStroke(ordinaryStroke);
        this.draw(rr);
        this.setStroke(this.currentStroke);
    }

    public void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.out.println("% fillRoundRect()");
        RoundRectangle2D.Double rr = new RoundRectangle2D.Double(x, y, width, height, arcWidth, arcHeight);
        this.fill(rr);
    }

    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.setStroke(ordinaryStroke);
        this.draw(new Arc2D.Double(x, y, width, height, startAngle, arcAngle, 0));
        this.setStroke(this.currentStroke);
    }

    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.fill(new Arc2D.Double(x, y, width, height, startAngle, arcAngle, 2));
    }

    public void fillOval(int x, int y, int width, int height) {
        this.out.println("% fillOval()");
        this.fill(new Ellipse2D.Double(x, y, width, height));
    }

    public void fillPolygon(int[] x, int[] y, int nPoints) {
        this.out.println("% fillPolygon()");
        this.fill(new Polygon(x, y, nPoints));
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        this.out.println("% drawLine()");
        this.setStroke(ordinaryStroke);
        this.out.println("newpath");
        this.out.println(String.valueOf(x1) + " " + y1 + " moveto");
        this.out.println(String.valueOf(x2) + " " + y2 + " lineto");
        this.out.println("stroke");
        this.setStroke(this.currentStroke);
    }

    public boolean drawImage(Image img, int x, int y, Color bgcolor, ImageObserver observer) {
        int w = img.getWidth(null);
        int h = img.getHeight(null);
        return this.drawImage(img, x, y, x + w, y + h, 0, 0, w - 1, h - 1, bgcolor, observer);
    }

    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, Color bgcolor, ImageObserver observer) {
        int n = 0;
        boolean flipx = false;
        boolean flipy = false;
        if (sx1 > sx2) {
            n = sx1;
            sx1 = sx2;
            sx2 = n;
            boolean bl = flipx = !flipx;
        }
        if (sy1 > sy2) {
            n = sy1;
            sy1 = sy2;
            sy2 = n;
            boolean bl = flipy = !flipy;
        }
        if (dx1 > dx2) {
            n = dx1;
            dx1 = dx2;
            dx2 = n;
            boolean bl = flipx = !flipx;
        }
        if (dy1 > dy2) {
            n = dy1;
            dy1 = dy2;
            dy2 = n;
            flipy = !flipy;
        }
        n = 0;
        int sw = sx2 - sx1;
        int sh = sy2 - sy1;
        int[] pixels = new int[sw * sh];
        int dw = dx2 - dx1;
        int dh = dy2 - dy1;
        this.out.println("% drawImage() 2");
        this.out.println("gsave");
        this.out.println(String.valueOf(dx1) + " " + dy1 + " translate");
        this.out.println(String.valueOf(dw) + " " + dh + " scale");
        this.out.println(String.valueOf(sw) + " " + sh + " 8 [" + (flipx ? -sw : sw) + " 0 0 " + (flipy ? -sh : sh) + " " + (flipx ? sw : 0) + " " + (flipy ? sh : 0) + " ]");
        this.out.println("{currentfile 3 string readhexstring pop} bind");
        this.out.println("false 3 colorimage");
        PixelGrabber pg = new PixelGrabber(img, sx1, sy1, sw, sh, pixels, 0, sw);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            System.err.println("interrupted waiting for pixels!");
            return false;
        }
        if ((pg.getStatus() & 0x80) != 0) {
            System.err.println("image fetch aborted or errored");
            return false;
        }
        int j = 0;
        while (j < sh) {
            int i = 0;
            while (i < sw) {
                this.out.print(this.colorTripleHex(new Color(pixels[j * sw + i])));
                if (++n % 11 == 0) {
                    this.out.println();
                }
                ++i;
            }
            ++j;
        }
        this.out.println();
        this.out.println("%%EOF");
        this.out.println("grestore");
        return true;
    }

    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, ImageObserver observer) {
        return this.drawImage(img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, null, observer);
    }

    public boolean drawImage(Image img, int x, int y, ImageObserver observer) {
        return this.drawImage(img, x, y, null, observer);
    }

    public boolean drawImage(Image img, int x, int y, int width, int height, Color bgcolor, ImageObserver observer) {
        int sw = img.getWidth(null);
        int sh = img.getHeight(null);
        return this.drawImage(img, x, y, x + width, y + height, 0, 0, sw - 1, sh - 1, bgcolor, observer);
    }

    public boolean drawImage(Image img, int x, int y, int width, int height, ImageObserver observer) {
        return this.drawImage(img, x, y, width, height, null, observer);
    }

    public void drawImage(BufferedImage img, BufferedImageOp op, int x, int y) {
        BufferedImage result = op.filter(img, null);
        this.drawImage((Image)result, x, y, null);
    }

    public boolean drawImage(Image img, AffineTransform xform, ImageObserver obs) {
        AffineTransform oldTransform = new AffineTransform(this.currentTransform);
        this.transform(xform);
        boolean ret = this.drawImage(img, 0, 0, null, obs);
        this.setTransform(oldTransform);
        return ret;
    }

    public void drawRenderableImage(RenderableImage img, AffineTransform xform) {
    }

    public void drawRenderedImage(RenderedImage img, AffineTransform xform) {
    }

    public void drawPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        this.setStroke(ordinaryStroke);
        this.draw(new Polygon(xPoints, yPoints, nPoints));
        this.setStroke(this.currentStroke);
    }

    public void drawString(String str, int x, int y) {
        this.drawString(str, (float)x, (float)y);
    }

    public void drawString(String str, float x, float y) {
        if (str.trim().equals("")) {
            return;
        }
        if (this.currentFontIsPS) {
            this.drawStringPSFont(str, x, y);
            return;
        }
        TextLayout text = new TextLayout(str, this.currentFont, this.getFontRenderContext());
        Shape s = text.getOutline(AffineTransform.getTranslateInstance(x, y));
        this.drawStringShape(s);
    }

    private void drawStringPSFont(String str, float x, float y) {
        this.out.println("% drawString PS font");
        this.out.println(String.valueOf(x) + " " + y + " moveto");
        this.saveAndInvertAxis();
        this.out.println("(" + str + ") show");
        this.restoreAxis();
    }

    private void saveAndInvertAxis() {
        this.popCTM();
        this.pushCTM();
        double[] test = new double[]{this.pageTransform.getScaleX(), this.pageTransform.getShearY(), this.pageTransform.getShearX(), this.pageTransform.getScaleY(), this.pageTransform.getTranslateX(), -this.pageTransform.getTranslateY() + this.pageY};
        double[] test2 = new double[]{this.currentTransform.getScaleX(), this.currentTransform.getShearY(), -this.currentTransform.getShearX(), -this.currentTransform.getScaleY(), this.currentTransform.getTranslateX(), this.currentTransform.getTranslateY()};
        AffineTransform total = new AffineTransform(test);
        total.concatenate(new AffineTransform(test2));
        this.concatCTM(total);
    }

    private void restoreAxis() {
        this.popCTM();
        this.pushCTM();
        AffineTransform total = new AffineTransform(this.pageTransform);
        total.concatenate(this.currentTransform);
        this.concatCTM(total);
    }

    private void drawStringShape(Shape s) {
        this.saveAndInvertAxis();
        PathIterator pi = s.getPathIterator(null);
        float[] coords = new float[6];
        while (!pi.isDone()) {
            switch (pi.currentSegment(coords)) {
                case 0: {
                    this.out.println(String.valueOf(coords[0]) + " " + (this.Y - (double)coords[1]) + " moveto");
                    this.cx = coords[0];
                    this.cy = coords[1];
                    break;
                }
                case 1: {
                    this.out.println(String.valueOf(coords[0]) + " " + (this.Y - (double)coords[1]) + " lineto");
                    this.cx = coords[0];
                    this.cy = coords[1];
                    break;
                }
                case 2: {
                    float x1 = (this.cx + 2.0f * coords[0]) / 3.0f;
                    float y1 = (this.cy + 2.0f * coords[1]) / 3.0f;
                    float x2 = (2.0f * coords[2] + coords[0]) / 3.0f;
                    float y2 = (2.0f * coords[3] + coords[1]) / 3.0f;
                    this.out.print(String.valueOf(x1) + " " + (this.Y - (double)y1) + " ");
                    this.out.print(String.valueOf(x2) + " " + (this.Y - (double)y2) + " ");
                    this.out.println(String.valueOf(coords[2]) + " " + (this.Y - (double)coords[3]) + " curveto");
                    this.cx = coords[2];
                    this.cy = coords[3];
                    break;
                }
                case 3: {
                    this.out.print(String.valueOf(coords[0]) + " " + (this.Y - (double)coords[1]) + " ");
                    this.out.print(String.valueOf(coords[2]) + " " + (this.Y - (double)coords[3]) + " ");
                    this.out.println(String.valueOf(coords[4]) + " " + (this.Y - (double)coords[5]) + " curveto");
                    this.cx = coords[4];
                    this.cy = coords[5];
                    break;
                }
                case 4: {
                    this.out.println("closepath");
                }
            }
            pi.next();
        }
        this.out.println("fill");
        this.restoreAxis();
    }

    public void setColor(Color c) {
        if (c.equals(this.currentColor)) {
            return;
        }
        this.gradientOn = false;
        this.currentColor = c;
        this.currentPaint = c;
        this.out.println(String.valueOf(this.colorTriple(c)) + " setrgbcolor");
    }

    public void clearRect(int x, int y, int width, int height) {
        this.out.println("% clearRect");
        Color c = this.currentColor;
        this.setColor(this.backgroundColor);
        this.fill(new Rectangle2D.Double(x, y, width, height));
        this.setColor(c);
    }

    public void clipRect(int x, int y, int width, int height) {
        this.clip(new Rectangle2D.Double(x, y, width, height));
    }

    public void copyArea(int x, int y, int width, int height, int dx, int dy) {
    }

    public void fillRect(int x, int y, int width, int height) {
        this.fill(new Rectangle2D.Double(x, y, width, height));
    }

    public void dispose() {
    }

    public void setClip(int x, int y, int width, int height) {
        this.out.println("% setClip()");
        this.setClip(new Rectangle2D.Double(x, y, width, height));
    }

    public void setClip(Shape s) {
        this.clip(s);
    }

    public Shape getClip() {
        return this.clipShape;
    }

    public Rectangle getClipBounds() {
        return this.clipShape.getBounds();
    }

    public Color getColor() {
        return this.currentColor;
    }

    public Font getFont() {
        return this.currentFont;
    }

    public FontMetrics getFontMetrics() {
        return this.getFontMetrics(this.currentFont);
    }

    public FontMetrics getFontMetrics(Font f) {
        return null;
    }

    public void setFont(Font font) {
        this.out.println("% setfont()");
        if (font == null) {
            font = new Font("Dialog", 0, 12);
        }
        this.currentFont = font;
        this.setPSFont();
    }

    private void setPSFont() {
        this.currentFontIsPS = false;
        String s = this.currentFont.getName();
        this.out.println("% setPSFont: Fontname: " + s);
        if (s.equalsIgnoreCase("Helvetica") || s.equalsIgnoreCase("SansSerif")) {
            this.out.print("/helveticaISO findfont ");
        } else if (s.equalsIgnoreCase("Times New Roman")) {
            this.out.print("/timesISO findfont ");
        } else if (s.equalsIgnoreCase("Courier")) {
            this.out.print("/courierISO findfont ");
        } else {
            return;
        }
        this.currentFontIsPS = true;
        this.out.print(String.valueOf(this.currentFont.getSize()) + " scalefont ");
        this.out.println("setfont");
    }

    public void setPaintMode() {
    }

    public void setXORMode(Color c1) {
    }

    public void close() {
        this.out.println("showpage");
        this.out.println("%%Trailer");
        this.out.println("grestore % restore original stuff");
        this.out.println("%%EOF");
        try {
            this.out.close();
        }
        catch (Exception exception) {}
        this.out = null;
    }

    public void addRenderingHints(Map hints) {
    }

    private void writeShape(Shape s) {
        PathIterator pi = s.getPathIterator(null);
        float[] coords = new float[6];
        while (!pi.isDone()) {
            switch (pi.currentSegment(coords)) {
                case 0: {
                    this.out.println(String.valueOf(coords[0]) + " " + coords[1] + " moveto");
                    this.cx = coords[0];
                    this.cy = coords[1];
                    break;
                }
                case 1: {
                    this.out.println(String.valueOf(coords[0]) + " " + coords[1] + " lineto");
                    this.cx = coords[0];
                    this.cy = coords[1];
                    break;
                }
                case 2: {
                    float x1 = (this.cx + 2.0f * coords[0]) / 3.0f;
                    float y1 = (this.cy + 2.0f * coords[1]) / 3.0f;
                    float x2 = (2.0f * coords[2] + coords[0]) / 3.0f;
                    float y2 = (2.0f * coords[3] + coords[1]) / 3.0f;
                    this.out.print(String.valueOf(x1) + " " + (this.Y - (double)y1) + " ");
                    this.out.print(String.valueOf(x2) + " " + (this.Y - (double)y2) + " ");
                    this.out.println(String.valueOf(coords[2]) + " " + (this.Y - (double)coords[3]) + " curveto");
                    this.cx = coords[2];
                    this.cy = coords[3];
                    break;
                }
                case 3: {
                    this.out.print(String.valueOf(coords[0]) + " " + coords[1] + " ");
                    this.out.print(String.valueOf(coords[2]) + " " + coords[3] + " ");
                    this.out.println(String.valueOf(coords[4]) + " " + coords[5] + " curveto");
                    this.cx = coords[4];
                    this.cy = coords[5];
                    break;
                }
                case 4: {
                    this.out.println("closepath");
                }
            }
            pi.next();
        }
    }

    public void clip(Shape s) {
        this.clipShape = s;
        this.out.println("% clip INACTIVE");
    }

    public void draw(Shape s) {
        if (!(this.currentStroke instanceof BasicStroke)) {
            this.fill(this.currentStroke.createStrokedShape(s));
        }
        this.out.println("% draw");
        this.writeShape(s);
        this.out.println("stroke");
    }

    public void drawGlyphVector(GlyphVector gv, float x, float y) {
        this.out.println("% drawGlyphVector");
        Shape s = gv.getOutline();
        this.drawStringShape(AffineTransform.getTranslateInstance(x, y).createTransformedShape(s));
    }

    public void drawString(AttributedCharacterIterator iterator, float x, float y) {
        TextLayout text = new TextLayout(iterator, this.getFontRenderContext());
        Shape s = text.getOutline(AffineTransform.getTranslateInstance(x, y));
        this.drawStringShape(s);
    }

    public void drawString(AttributedCharacterIterator iterator, int x, int y) {
        this.drawString(iterator, (float)x, (float)y);
    }

    public void fill(Shape s) {
        this.out.println("% fill");
        if (!this.gradientOn) {
            this.writeShape(s);
            this.out.println("fill");
        } else {
            this.out.println("gsave");
            this.writeShape(s);
            this.out.println("clip");
            this.writeGradient();
            this.out.println("shfill");
            this.out.println("grestore");
        }
    }

    public Color getBackground() {
        return this.backgroundColor;
    }

    public Composite getComposite() {
        return null;
    }

    public GraphicsConfiguration getDeviceConfiguration() {
        this.out.println("% getDeviceConfiguration()");
        return null;
    }

    public FontRenderContext getFontRenderContext() {
        this.out.println("% getFontRenderContext()");
        double[] scaling = new double[]{this.pageTransform.getScaleX(), 0.0, 0.0, -this.pageTransform.getScaleY(), 0.0, 0.0};
        return new FontRenderContext(new AffineTransform(scaling), false, true);
    }

    public Paint getPaint() {
        return this.currentPaint;
    }

    public Object getRenderingHint(RenderingHints.Key hintKey) {
        return this.renderingHints.get(hintKey);
    }

    public RenderingHints getRenderingHints() {
        return this.renderingHints;
    }

    public Stroke getStroke() {
        return this.currentStroke;
    }

    public AffineTransform getTransform() {
        return this.currentTransform;
    }

    public boolean hit(Rectangle rect, Shape s, boolean onStroke) {
        Rectangle2D.Double r = new Rectangle2D.Double(rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight());
        return s.intersects(r);
    }

    public void setBackground(Color color) {
        this.out.println("% setBackground(" + color + ")");
        this.backgroundColor = color;
    }

    public void setComposite(Composite comp) {
    }

    public void setPaint(Paint paint) {
        this.currentPaint = paint;
        this.gradientOn = false;
        if (paint instanceof Color) {
            this.setColor((Color)paint);
            return;
        }
        if (paint instanceof GradientPaint) {
            this.gradientOn = true;
            return;
        }
    }

    private String colorTriple(Color c) {
        return String.valueOf((double)c.getRed() / 255.0) + " " + (double)c.getGreen() / 255.0 + " " + (double)c.getBlue() / 255.0;
    }

    private String colorTripleHex(Color c) {
        String r = "00" + Integer.toHexString(c.getRed());
        r = r.substring(r.length() - 2);
        String g = "00" + Integer.toHexString(c.getGreen());
        g = g.substring(g.length() - 2);
        String b = "00" + Integer.toHexString(c.getBlue());
        b = b.substring(b.length() - 2);
        return String.valueOf(r) + g + b;
    }

    private void writeGradient() {
        GradientPaint paint = (GradientPaint)this.currentPaint;
        this.out.println("% writeGradient()");
        int n = 1;
        Point2D p1 = this.currentTransform.transform(paint.getPoint1(), null);
        Point2D p2 = this.currentTransform.transform(paint.getPoint2(), null);
        double x = p1.getX();
        double y = p1.getY();
        double dx = p2.getX() - x;
        double dy = p2.getY() - y;
        while (x + (double)n * dx < this.pageY && y + (double)n * dy < this.pageX && x + (double)n * dx > 0.0 && y + (double)n * dy > 0.0) {
            ++n;
        }
        this.out.println("<<");
        this.out.println("/ShadingType 2");
        this.out.println("/ColorSpace [ /DeviceRGB ]");
        this.out.print("/Coords [");
        this.out.print(String.valueOf(x) + " " + y + " " + (x + (double)n * dx) + " " + (y + (double)n * dy) + " ");
        this.out.println("]");
        this.out.println("/Function <<");
        this.out.println("/FunctionType 0");
        this.out.println("/Order 1");
        this.out.println("/Domain [ 0 1 ]");
        this.out.println("/Range [ 0 1  0 1  0 1 ]");
        this.out.println("/BitsPerSample 8");
        this.out.println("/Size [ " + (1 + n) + " ]");
        this.out.print("/DataSource < " + this.colorTripleHex(paint.getColor1()) + " " + this.colorTripleHex(paint.getColor2()) + " ");
        while (n > 1) {
            if (paint.isCyclic()) {
                if (n % 2 == 1) {
                    this.out.print(String.valueOf(this.colorTripleHex(paint.getColor1())) + " ");
                } else {
                    this.out.print(String.valueOf(this.colorTripleHex(paint.getColor2())) + " ");
                }
            } else {
                this.out.print(String.valueOf(this.colorTripleHex(paint.getColor2())) + " ");
            }
            --n;
        }
        this.out.println(">");
        this.out.println(">>");
        this.out.println(">>");
    }

    public void setRenderingHint(RenderingHints.Key hintKey, Object hintValue) {
    }

    public void setRenderingHints(Map hints) {
    }

    public void setStroke(Stroke s) {
        this.currentStroke = s;
        if (!(s instanceof BasicStroke)) {
            return;
        }
        BasicStroke bs = (BasicStroke)s;
        this.out.println("% setStroke()");
        try {
            this.out.println(String.valueOf(bs.getLineWidth()) + " setlinewidth");
            float[] dashArray = bs.getDashArray();
            if (dashArray != null) {
                this.out.print("[ ");
                int i = 0;
                while (i < dashArray.length) {
                    this.out.print(String.valueOf(dashArray[i]) + " ");
                    ++i;
                }
                this.out.println("] " + bs.getDashPhase() + " setdash");
            } else {
                this.out.println("[] 0 setdash");
            }
            switch (bs.getEndCap()) {
                case 0: {
                    this.out.println("0 setlinecap");
                    break;
                }
                case 1: {
                    this.out.println("1 setlinecap");
                    break;
                }
                case 2: {
                    this.out.println("2 setlinecap");
                }
            }
            switch (bs.getLineJoin()) {
                case 2: {
                    this.out.println("2 setlinejoin");
                    break;
                }
                case 0: {
                    this.out.println("0 setlinejoin");
                    this.out.println(String.valueOf(bs.getMiterLimit()) + " setmiterlimit");
                    break;
                }
                case 1: {
                    this.out.println("1 setlinejoin");
                }
            }
        }
        catch (Exception exception) {
            this.out.println("% Exception in setStroke()");
        }
    }

    private void concatCTM(AffineTransform Tx) {
        double[] matrixElements = new double[6];
        Tx.getMatrix(matrixElements);
        this.out.print("[ ");
        int i = 0;
        while (i < 6) {
            this.out.print(String.valueOf(matrixElements[i]) + " ");
            ++i;
        }
        this.out.println("] concat");
    }

    public void setTransform(AffineTransform Tx) {
        this.currentTransform = Tx;
        AffineTransform totalTransform = new AffineTransform(this.pageTransform);
        totalTransform.concatenate(this.currentTransform);
        this.out.println("% setTransform()");
        this.out.println("% pageTransform:" + this.pageTransform);
        this.out.println("% currentTransform:" + this.currentTransform);
        this.out.println("% totalTransform:" + totalTransform);
        this.popCTM();
        this.pushCTM();
        this.concatCTM(totalTransform);
    }

    public void transform(AffineTransform Tx) {
        this.currentTransform.concatenate(Tx);
        this.concatCTM(Tx);
    }

    public void shear(double shx, double shy) {
        this.out.println("% shear()");
        AffineTransform Tx = new AffineTransform();
        Tx.shear(shx, shy);
        this.transform(Tx);
    }

    public void translate(int x, int y) {
        this.out.println("% translate()");
        AffineTransform Tx = new AffineTransform();
        Tx.translate(x, y);
        this.transform(Tx);
    }

    public void translate(double x, double y) {
        this.out.println("% translate(" + x + ", " + y + ")");
        AffineTransform Tx = new AffineTransform();
        Tx.translate(x, y);
        this.transform(Tx);
    }

    public void rotate(double theta) {
        this.out.println("% rotate(" + theta + ")");
        AffineTransform Tx = new AffineTransform();
        Tx.rotate(theta);
        this.transform(Tx);
    }

    public void rotate(double theta, double x, double y) {
        this.out.println("% rotate()");
        AffineTransform Tx = new AffineTransform();
        Tx.rotate(theta, x, y);
        this.transform(Tx);
    }

    public void scale(double sx, double sy) {
        this.out.println("% scale(" + sx + ", " + sy + ")");
        AffineTransform Tx = new AffineTransform();
        Tx.scale(sx, sy);
        this.transform(Tx);
    }
}

