/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.print;

import gnu.java.awt.peer.gtk.CairoSurface;
import gnu.java.awt.print.SpooledDocument;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.image.ImageObserver;
import java.awt.image.PixelGrabber;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterGraphics;
import java.awt.print.PrinterJob;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.text.AttributedCharacterIterator;

public class JavaPrinterGraphics
extends Graphics
implements PrinterGraphics {
    private Graphics g;
    private PrinterJob printerJob;
    private static final double DPI = 72.0;
    private int xSize;
    private int ySize;
    private Image image;

    public JavaPrinterGraphics(PrinterJob printerJob) {
        this.printerJob = printerJob;
    }

    public SpooledDocument spoolPostScript(Printable printable, PageFormat pageFormat, Pageable pageable) throws PrinterException {
        try {
            File temp = File.createTempFile("cpspool", ".ps");
            temp.deleteOnExit();
            PrintWriter out = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(temp), "ISO8859_1"), 1000000));
            this.writePSHeader(out);
            if (pageable != null) {
                int index = 0;
                while (index < pageable.getNumberOfPages()) {
                    this.spoolPage(out, pageable.getPrintable(index), pageable.getPageFormat(index), index);
                    ++index;
                }
            } else {
                int index = 0;
                while (this.spoolPage(out, printable, pageFormat, index++) == 0) {
                }
            }
            out.println("%%Trailer");
            out.println("%%EOF");
            out.close();
            return new SpooledDocument(temp);
        }
        catch (IOException e) {
            PrinterException pe = new PrinterException();
            pe.initCause(e);
            throw pe;
        }
    }

    public int spoolPage(PrintWriter out, Printable printable, PageFormat pageFormat, int index) throws IOException, PrinterException {
        this.initImage(pageFormat);
        if (printable.print(this, pageFormat, index) == 1) {
            return 1;
        }
        this.g.dispose();
        this.g = null;
        this.writePage(out, pageFormat);
        return 0;
    }

    private void initImage(PageFormat pageFormat) {
        this.xSize = (int)(72.0 * pageFormat.getWidth() / 72.0);
        this.ySize = (int)(72.0 * pageFormat.getHeight() / 72.0);
        if (pageFormat.getOrientation() != 1) {
            int t = this.xSize;
            this.xSize = this.ySize;
            this.ySize = t;
        }
        this.image = CairoSurface.getBufferedImage(this.xSize, this.ySize);
        this.g = this.image.getGraphics();
        this.setColor(Color.white);
        this.fillRect(0, 0, this.xSize, this.ySize);
        this.setColor(Color.black);
    }

    private void writePSHeader(PrintWriter out) {
        out.println("%!PS-Adobe-3.0");
        out.println("%%Title: " + this.printerJob.getJobName());
        out.println("%%Creator: GNU Classpath ");
        out.println("%%DocumentData: Clean8Bit");
        out.println("%%DocumentNeededResources: font Times-Roman Helvetica Courier");
        out.println("%%EndComments");
        out.println("%%BeginProlog");
        out.println("%%EndProlog");
        out.println("%%BeginSetup");
        out.println("%%EndFeature");
        out.println("%%EndSetup");
    }

    private void writePage(PrintWriter out, PageFormat pageFormat) {
        out.println("%%BeginPageSetup");
        Paper p = pageFormat.getPaper();
        double pWidth = p.getWidth();
        double pHeight = p.getHeight();
        if (pageFormat.getOrientation() == 1) {
            out.println("%%Orientation: Portrait");
        } else {
            out.println("%%Orientation: Landscape");
            double t = pWidth;
            pWidth = pHeight;
            pHeight = t;
        }
        out.println("gsave % first save");
        out.println("<< /PageSize [" + pWidth + " " + pHeight + "] >> setpagedevice");
        AffineTransform pageTransform = new AffineTransform();
        if (pageFormat.getOrientation() == 2) {
            pageTransform.translate(pWidth, pHeight);
            pageTransform.scale(-1.0, -1.0);
        }
        this.concatCTM(out, pageTransform);
        out.println("%%EndPageSetup");
        out.println("gsave");
        out.println(String.valueOf(this.xSize) + " " + this.ySize + " 8 [1 0 0 -1 0 " + this.ySize + " ]");
        out.println("{currentfile 3 string readhexstring pop} bind");
        out.println("false 3 colorimage");
        int[] pixels = new int[this.xSize * this.ySize];
        PixelGrabber pg = new PixelGrabber(this.image, 0, 0, this.xSize, this.ySize, pixels, 0, this.xSize);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            out.println("% Bug getting pixels!");
        }
        int n = 0;
        int j = 0;
        while (j < this.ySize) {
            int i = 0;
            while (i < this.xSize) {
                out.print(this.colorTripleHex(pixels[j * this.xSize + i]));
                if (++n % 11 == 0) {
                    out.println();
                }
                ++i;
            }
            ++j;
        }
        out.println();
        out.println("%%EOF");
        out.println("grestore");
        out.println("showpage");
    }

    private String colorTripleHex(int num) {
        String s = "";
        try {
            s = Integer.toHexString(num & 0xFFFFFF);
            if (s.length() < 6) {
                s = "000000" + s;
                return s.substring(s.length() - 6);
            }
        }
        catch (Exception exception) {
            s = "FFFFFF";
        }
        return s;
    }

    private void concatCTM(PrintWriter out, AffineTransform Tx) {
        double[] matrixElements = new double[6];
        Tx.getMatrix(matrixElements);
        out.print("[ ");
        int i = 0;
        while (i < 6) {
            out.print(String.valueOf(matrixElements[i]) + " ");
            ++i;
        }
        out.println("] concat");
    }

    public PrinterJob getPrinterJob() {
        return this.printerJob;
    }

    public void clearRect(int x, int y, int width, int height) {
        this.g.clearRect(x, y, width, height);
    }

    public void clipRect(int x, int y, int width, int height) {
        this.g.clipRect(x, y, width, height);
    }

    public void copyArea(int x, int y, int width, int height, int dx, int dy) {
        this.g.copyArea(x, y, width, height, dx, dy);
    }

    public Graphics create() {
        return this.g.create();
    }

    public void dispose() {
    }

    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.g.drawArc(x, y, width, height, startAngle, arcAngle);
    }

    public boolean drawImage(Image img, int x, int y, Color bgcolor, ImageObserver observer) {
        return this.g.drawImage(img, x, y, bgcolor, observer);
    }

    public boolean drawImage(Image img, int x, int y, ImageObserver observer) {
        return this.g.drawImage(img, x, y, observer);
    }

    public boolean drawImage(Image img, int x, int y, int width, int height, Color bgcolor, ImageObserver observer) {
        return this.g.drawImage(img, x, y, width, height, bgcolor, observer);
    }

    public boolean drawImage(Image img, int x, int y, int width, int height, ImageObserver observer) {
        return this.g.drawImage(img, x, y, width, height, observer);
    }

    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, Color bgcolor, ImageObserver observer) {
        return this.g.drawImage(img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, bgcolor, observer);
    }

    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, ImageObserver observer) {
        return this.g.drawImage(img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, observer);
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        this.g.drawLine(x1, y1, x2, y2);
    }

    public void drawOval(int x, int y, int width, int height) {
        this.g.drawOval(x, y, width, height);
    }

    public void drawPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        this.g.drawPolygon(xPoints, yPoints, nPoints);
    }

    public void drawPolyline(int[] xPoints, int[] yPoints, int nPoints) {
        this.g.drawPolyline(xPoints, yPoints, nPoints);
    }

    public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.g.drawRoundRect(x, y, width, height, arcWidth, arcHeight);
    }

    public void drawString(AttributedCharacterIterator iterator, int x, int y) {
        this.g.drawString(iterator, x, y);
    }

    public void drawString(String str, int x, int y) {
        this.g.drawString(str, x, y);
    }

    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.g.fillArc(x, y, width, height, startAngle, arcAngle);
    }

    public void fillOval(int x, int y, int width, int height) {
        this.g.fillOval(x, y, width, height);
    }

    public void fillPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        this.g.fillPolygon(xPoints, yPoints, nPoints);
    }

    public void fillRect(int x, int y, int width, int height) {
        this.g.fillRect(x, y, width, height);
    }

    public void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.g.fillRoundRect(x, y, width, height, arcWidth, arcHeight);
    }

    public Shape getClip() {
        return this.g.getClip();
    }

    public Rectangle getClipBounds() {
        return this.g.getClipBounds();
    }

    public Color getColor() {
        return this.g.getColor();
    }

    public Font getFont() {
        return this.g.getFont();
    }

    public FontMetrics getFontMetrics(Font f) {
        return this.g.getFontMetrics(f);
    }

    public void setClip(int x, int y, int width, int height) {
        this.g.setClip(x, y, width, height);
    }

    public void setClip(Shape clip) {
        this.g.setClip(clip);
    }

    public void setColor(Color c) {
        this.g.setColor(c);
    }

    public void setFont(Font font) {
        this.g.setFont(font);
    }

    public void setPaintMode() {
        this.g.setPaintMode();
    }

    public void setXORMode(Color c1) {
        this.g.setXORMode(c1);
    }

    public void translate(int x, int y) {
        this.g.translate(x, y);
    }
}

