/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.color;

import java.awt.color.ICC_Profile;
import java.nio.ByteBuffer;

public class ColorLookUpTable {
    private static float[] D50 = new float[]{0.96422f, 1.0f, 0.82521f};
    int nIn;
    int nOut;
    int nInTableEntries;
    int nOutTableEntries;
    int gridpoints;
    int nClut;
    double[][] inTable;
    short[][] outTable;
    double[] clut;
    float[][] inMatrix;
    boolean useMatrix = false;
    int[] multiplier;
    int[] offsets;
    boolean inputLab;
    boolean outputLab;

    public ColorLookUpTable(ICC_Profile profile, int tag) {
        switch (tag) {
            case 1093812784: 
            case 1093812785: 
            case 1093812786: {
                if (profile.getColorSpaceType() == 0) {
                    this.useMatrix = true;
                }
                this.inputLab = false;
                this.outputLab = profile.getPCSType() == 1;
                break;
            }
            case 1110589744: 
            case 1110589745: 
            case 1110589746: {
                if (profile.getPCSType() == 0) {
                    this.useMatrix = true;
                }
                this.inputLab = profile.getPCSType() == 1;
                this.outputLab = false;
                break;
            }
            default: {
                throw new IllegalArgumentException("Not a clut-type tag.");
            }
        }
        byte[] data = profile.getData(tag);
        if (data == null) {
            throw new IllegalArgumentException("Unsuitable profile, does not contain a CLUT.");
        }
        if (data[0] != 109 || data[1] != 102 || data[2] != 116) {
            throw new IllegalArgumentException("Unsuitable profile, invalid CLUT data.");
        }
        if (data[3] == 50) {
            this.readClut16(data);
        } else if (data[3] == 49) {
            this.readClut8(data);
        } else {
            throw new IllegalArgumentException("Unknown/invalid CLUT type.");
        }
    }

    private void readClut16(byte[] data) {
        int i;
        int j;
        ByteBuffer buf = ByteBuffer.wrap(data);
        this.nIn = data[8] & 0xFF;
        this.nOut = data[9] & 0xFF;
        this.nInTableEntries = buf.getShort(48);
        this.nOutTableEntries = buf.getShort(50);
        this.gridpoints = data[10] & 0xFF;
        this.inMatrix = new float[3][3];
        int i2 = 0;
        while (i2 < 3) {
            j = 0;
            while (j < 3) {
                this.inMatrix[i2][j] = (float)buf.getInt(12 + (i2 * 3 + j) * 4) / 65536.0f;
                ++j;
            }
            ++i2;
        }
        this.inTable = new double[this.nIn][this.nInTableEntries];
        int channel = 0;
        while (channel < this.nIn) {
            i = 0;
            while (i < this.nInTableEntries) {
                this.inTable[channel][i] = (double)(buf.getShort(52 + (channel * this.nInTableEntries + i) * 2) & 0xFFFF) / 65536.0;
                ++i;
            }
            ++channel;
        }
        this.nClut = this.nOut;
        this.multiplier = new int[this.nIn];
        this.multiplier[this.nIn - 1] = this.nOut;
        i2 = 0;
        while (i2 < this.nIn) {
            this.nClut *= this.gridpoints;
            if (i2 > 0) {
                this.multiplier[this.nIn - i2 - 1] = this.multiplier[this.nIn - i2] * this.gridpoints;
            }
            ++i2;
        }
        int clutOffset = 52 + this.nIn * this.nInTableEntries * 2;
        this.clut = new double[this.nClut];
        i = 0;
        while (i < this.nClut) {
            this.clut[i] = (double)(buf.getShort(clutOffset + i * 2) & 0xFFFF) / 65536.0;
            ++i;
        }
        this.outTable = new short[this.nOut][this.nOutTableEntries];
        int channel2 = 0;
        while (channel2 < this.nOut) {
            int i3 = 0;
            while (i3 < this.nOutTableEntries) {
                this.outTable[channel2][i3] = buf.getShort(clutOffset + (this.nClut + channel2 * this.nOutTableEntries + i3) * 2);
                ++i3;
            }
            ++channel2;
        }
        this.offsets = new int[1 << this.nIn];
        this.offsets[0] = 0;
        j = 0;
        while (j < this.nIn) {
            int factor = 1 << j;
            int i4 = 0;
            while (i4 < factor) {
                this.offsets[factor + i4] = this.offsets[i4] + this.multiplier[j];
                ++i4;
            }
            ++j;
        }
    }

    private void readClut8(byte[] data) {
        int i;
        int j;
        ByteBuffer buf = ByteBuffer.wrap(data);
        this.nIn = data[8] & 0xFF;
        this.nOut = data[9] & 0xFF;
        this.nInTableEntries = 256;
        this.nOutTableEntries = 256;
        this.gridpoints = data[10] & 0xFF;
        this.inMatrix = new float[3][3];
        int i2 = 0;
        while (i2 < 3) {
            j = 0;
            while (j < 3) {
                this.inMatrix[i2][j] = (float)buf.getInt(12 + (i2 * 3 + j) * 4) / 65536.0f;
                ++j;
            }
            ++i2;
        }
        this.inTable = new double[this.nIn][this.nInTableEntries];
        int channel = 0;
        while (channel < this.nIn) {
            i = 0;
            while (i < this.nInTableEntries) {
                this.inTable[channel][i] = (double)(buf.get(48 + (channel * this.nInTableEntries + i)) & 0xFF) / 255.0;
                ++i;
            }
            ++channel;
        }
        this.nClut = this.nOut;
        this.multiplier = new int[this.nIn];
        this.multiplier[this.nIn - 1] = this.nOut;
        i2 = 0;
        while (i2 < this.nIn) {
            this.nClut *= this.gridpoints;
            if (i2 > 0) {
                this.multiplier[this.nIn - i2 - 1] = this.multiplier[this.nIn - i2] * this.gridpoints;
            }
            ++i2;
        }
        int clutOffset = 48 + this.nIn * this.nInTableEntries;
        this.clut = new double[this.nClut];
        i = 0;
        while (i < this.nClut) {
            this.clut[i] = (double)(buf.get(clutOffset + i) & 0xFF) / 255.0;
            ++i;
        }
        this.outTable = new short[this.nOut][this.nOutTableEntries];
        int channel2 = 0;
        while (channel2 < this.nOut) {
            int i3 = 0;
            while (i3 < this.nOutTableEntries) {
                this.outTable[channel2][i3] = (short)(buf.get(clutOffset + this.nClut + channel2 * this.nOutTableEntries + i3) * 257);
                ++i3;
            }
            ++channel2;
        }
        this.offsets = new int[1 << this.nIn];
        this.offsets[0] = 0;
        j = 0;
        while (j < this.nIn) {
            int factor = 1 << j;
            int i4 = 0;
            while (i4 < factor) {
                this.offsets[factor + i4] = this.offsets[i4] + this.multiplier[j];
                ++i4;
            }
            ++j;
        }
    }

    float[] lookup(float[] in) {
        int i;
        float[] in2 = new float[in.length];
        if (this.useMatrix) {
            i = 0;
            while (i < 3) {
                in2[i] = in[0] * this.inMatrix[i][0] + in[1] * this.inMatrix[i][1] + in[2] * this.inMatrix[i][2];
                ++i;
            }
        } else if (this.inputLab) {
            in2 = this.XYZtoLab(in);
        } else {
            System.arraycopy(in, 0, in2, 0, in.length);
        }
        i = 0;
        while (i < this.nIn) {
            int index = (int)Math.floor((double)in2[i] * (double)(this.nInTableEntries - 1));
            if (index >= this.nInTableEntries - 1) {
                in2[i] = (float)this.inTable[i][this.nInTableEntries - 1];
            } else if (index < 0) {
                in2[i] = (float)this.inTable[i][0];
            } else {
                double alpha = (double)in2[i] * ((double)this.nInTableEntries - 1.0) - (double)index;
                in2[i] = (float)(this.inTable[i][index] * (1.0 - alpha) + this.inTable[i][index + 1] * alpha);
            }
            ++i;
        }
        double[] output2 = new double[this.nOut];
        double[] weights = new double[1 << this.nIn];
        double[] clutalpha = new double[this.nIn];
        int offset = 0;
        int i2 = 0;
        while (i2 < this.nIn) {
            int index = (int)Math.floor((double)in2[i2] * ((double)this.gridpoints - 1.0));
            double alpha = (double)in2[i2] * ((double)this.gridpoints - 1.0) - (double)index;
            if (index >= this.gridpoints - 1) {
                index = this.gridpoints - 1;
                alpha = 1.0;
            } else if (index < 0) {
                index = 0;
            }
            clutalpha[i2] = alpha;
            offset += index * this.multiplier[i2];
            ++i2;
        }
        weights[0] = 1.0;
        int j = 0;
        while (j < this.nIn) {
            int factor = 1 << j;
            int i3 = 0;
            while (i3 < factor) {
                weights[factor + i3] = weights[i3] * clutalpha[j];
                int n = i3++;
                weights[n] = weights[n] * (1.0 - clutalpha[j]);
            }
            ++j;
        }
        i2 = 0;
        while (i2 < this.nOut) {
            output2[i2] = weights[0] * this.clut[offset + i2];
            ++i2;
        }
        i2 = 1;
        while (i2 < 1 << this.nIn) {
            int offset2 = offset + this.offsets[i2];
            int f = 0;
            while (f < this.nOut) {
                int n = f;
                output2[n] = output2[n] + weights[i2] * this.clut[offset2 + f];
                ++f;
            }
            ++i2;
        }
        float[] output = new float[this.nOut];
        int i4 = 0;
        while (i4 < this.nOut) {
            int index = (int)Math.floor(output2[i4] * ((double)this.nOutTableEntries - 1.0));
            if (index >= this.nOutTableEntries - 1) {
                output[i4] = this.outTable[i4][this.nOutTableEntries - 1];
            } else if (index < 0) {
                output[i4] = this.outTable[i4][0];
            } else {
                double a = output2[i4] * ((double)this.nOutTableEntries - 1.0) - (double)index;
                output[i4] = (float)((double)(this.outTable[i4][index] & 0xFFFF) * (1.0 - a) + (double)(this.outTable[i4][index + 1] & 0xFFFF) * a) / 65536.0f;
            }
            ++i4;
        }
        if (this.outputLab) {
            return this.LabtoXYZ(output);
        }
        return output;
    }

    private float[] LabtoXYZ(float[] in) {
        in[0] = (float)(100.392156862745 * (double)in[0]);
        in[1] = in[1] * 256.0f - 128.0f;
        in[2] = in[2] * 256.0f - 128.0f;
        float[] out = new float[3];
        out[1] = (in[0] + 16.0f) / 116.0f;
        out[0] = in[1] / 500.0f + out[1];
        out[2] = out[1] - in[2] / 200.0f;
        int i = 0;
        while (i < 3) {
            double exp = out[i] * out[i] * out[i];
            out[i] = exp <= 0.008856 ? (out[i] - 0.13793103f) / 7.787f : (float)exp;
            out[i] = D50[i] * out[i];
            ++i;
        }
        return out;
    }

    private float[] XYZtoLab(float[] in) {
        float[] temp = new float[3];
        int i = 0;
        while (i < 3) {
            temp[i] = in[i] / D50[i];
            temp[i] = temp[i] <= 0.008856f ? 7.787069f * temp[i] + 0.13793103f : (float)Math.exp(0.3333333333333333 * Math.log(temp[i]));
            ++i;
        }
        float[] out = new float[]{116.0f * temp[1] - 16.0f, 500.0f * (temp[0] - temp[1]), 200.0f * (temp[1] - temp[2])};
        out[0] = (float)((double)out[0] / 100.392156862745);
        out[1] = (out[1] + 128.0f) / 256.0f;
        out[2] = (out[2] + 128.0f) / 256.0f;
        int i2 = 0;
        while (i2 < 3) {
            if (out[i2] < 0.0f) {
                out[i2] = 0.0f;
            }
            if (out[i2] > 1.0f) {
                out[i2] = 1.0f;
            }
            ++i2;
        }
        return out;
    }
}

