/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import javax.management.MBeanFeatureInfo;
import javax.management.MBeanParameterInfo;

public class MBeanOperationInfo
extends MBeanFeatureInfo
implements Cloneable {
    private static final long serialVersionUID = -6178860474881375330L;
    public static final int INFO = 0;
    public static final int ACTION = 1;
    public static final int ACTION_INFO = 2;
    public static final int UNKNOWN = 3;
    private String type;
    private MBeanParameterInfo[] signature;
    private int impact;

    public MBeanOperationInfo(String desc, Method method) {
        super(method.getName(), desc);
        Type[] paramTypes = method.getGenericParameterTypes();
        this.signature = new MBeanParameterInfo[paramTypes.length];
        int a = 0;
        while (a < paramTypes.length) {
            Type t = paramTypes[a];
            this.signature[a] = t instanceof Class ? new MBeanParameterInfo(null, ((Class)t).getName(), null) : new MBeanParameterInfo(null, t.toString(), null);
            ++a;
        }
        Type retType = method.getGenericReturnType();
        this.type = retType instanceof Class ? ((Class)retType).getName() : retType.toString();
        this.impact = method.getReturnType() == Void.TYPE ? (paramTypes.length == 0 ? 3 : 1) : (paramTypes.length == 0 ? 0 : 2);
    }

    public MBeanOperationInfo(String name, String desc, MBeanParameterInfo[] sig, String type, int impact) {
        super(name, desc);
        if (sig == null) {
            this.signature = new MBeanParameterInfo[0];
        } else {
            this.signature = new MBeanParameterInfo[sig.length];
            System.arraycopy(sig, 0, this.signature, 0, sig.length);
        }
        this.type = type;
        this.impact = impact;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException("clone() called on non-cloneable object.");
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MBeanOperationInfo)) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        MBeanOperationInfo o = (MBeanOperationInfo)obj;
        MBeanParameterInfo[] sig = o.getSignature();
        int a = 0;
        while (a < this.signature.length) {
            if (a == sig.length) {
                return true;
            }
            if (!this.signature[a].equals(sig[a])) {
                return false;
            }
            ++a;
        }
        return this.type.equals(o.getReturnType()) && this.impact == o.getImpact();
    }

    public int getImpact() {
        return this.impact;
    }

    public String getReturnType() {
        return this.type;
    }

    public MBeanParameterInfo[] getSignature() {
        return (MBeanParameterInfo[])this.signature.clone();
    }

    public int hashCode() {
        return super.hashCode() + Arrays.hashCode(this.signature) + this.type.hashCode() + Integer.valueOf(this.impact).hashCode();
    }

    public String toString() {
        if (this.string == null) {
            String impactString;
            switch (this.impact) {
                case 0: {
                    impactString = "INFO";
                    break;
                }
                case 1: {
                    impactString = "ACTION";
                    break;
                }
                case 2: {
                    impactString = "ACTION_INFO";
                    break;
                }
                case 3: {
                    impactString = "UNKNOWN";
                    break;
                }
                default: {
                    impactString = "ERRONEOUS VALUE";
                }
            }
            super.toString();
            this.string = String.valueOf(this.string.substring(0, this.string.length() - 1)) + ",returnType=" + this.type + ",impact=" + impactString + ",signature=" + Arrays.toString(this.signature) + "]";
        }
        return this.string;
    }
}

