/*
 * Decompiled with CFR 0.152.
 */
package java.awt.dnd;

import gnu.classpath.NotImplementedException;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.FlavorMap;
import java.awt.datatransfer.SystemFlavorMap;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DnDEventMulticaster;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DragSourceMotionListener;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.dnd.MouseDragGestureRecognizer;
import java.awt.dnd.peer.DragSourceContextPeer;
import java.io.Serializable;
import java.util.EventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DragSource
implements Serializable {
    private static final long serialVersionUID = 6236096958971414066L;
    public static final Cursor DefaultCopyDrop = null;
    public static final Cursor DefaultMoveDrop = null;
    public static final Cursor DefaultLinkDrop = null;
    public static final Cursor DefaultCopyNoDrop = null;
    public static final Cursor DefaultMoveNoDrop = null;
    public static final Cursor DefaultLinkNoDrop = null;
    private transient FlavorMap flavorMap = SystemFlavorMap.getDefaultFlavorMap();
    private transient DragSourceListener dragSourceListener;
    private transient DragSourceMotionListener dragSourceMotionListener;
    private static DragSource ds;
    private DragSourceContextPeer peer;
    private DragSourceContext context;

    public DragSource() {
        if (GraphicsEnvironment.isHeadless()) {
            ds = null;
            throw new HeadlessException();
        }
    }

    public static DragSource getDefaultDragSource() {
        if (GraphicsEnvironment.isHeadless()) {
            ds = null;
            throw new HeadlessException();
        }
        if (ds == null) {
            ds = new DragSource();
        }
        return ds;
    }

    public static boolean isDragImageSupported() {
        return false;
    }

    public void startDrag(DragGestureEvent trigger, Cursor dragCursor, Image dragImage, Point imageOffset, Transferable trans, DragSourceListener dsl, FlavorMap map) {
        try {
            this.flavorMap = map;
            if (this.peer == null) {
                this.peer = Toolkit.getDefaultToolkit().createDragSourceContextPeer(trigger);
            }
            if (this.context == null) {
                this.context = this.createDragSourceContext(this.peer, trigger, dragCursor, dragImage, imageOffset, trans, dsl);
            }
            if (this.peer == null) {
                throw new InvalidDnDOperationException();
            }
            this.peer.startDrag(this.context, dragCursor, dragImage, imageOffset);
        }
        catch (Exception exception) {
            throw new InvalidDnDOperationException("Drag and Drop system is unable to initiate a drag operation.");
        }
    }

    public void startDrag(DragGestureEvent trigger, Cursor dragCursor, Transferable trans, DragSourceListener dsl, FlavorMap map) {
        this.startDrag(trigger, dragCursor, null, null, trans, dsl, map);
    }

    public void startDrag(DragGestureEvent trigger, Cursor dragCursor, Image dragImage, Point imageOffset, Transferable trans, DragSourceListener dsl) {
        this.startDrag(trigger, dragCursor, dragImage, imageOffset, trans, dsl, null);
    }

    public void startDrag(DragGestureEvent trigger, Cursor dragCursor, Transferable trans, DragSourceListener dsl) {
        this.startDrag(trigger, dragCursor, null, null, trans, dsl, null);
    }

    protected DragSourceContext createDragSourceContext(DragSourceContextPeer peer, DragGestureEvent dge, Cursor cursor, Image image, Point offset, Transferable t, DragSourceListener dsl) {
        return new DragSourceContext(peer, dge, cursor, image, offset, t, dsl);
    }

    public FlavorMap getFlavorMap() {
        return this.flavorMap;
    }

    public <T extends DragGestureRecognizer> T createDragGestureRecognizer(Class<T> recognizer, Component c, int actions, DragGestureListener dgl) {
        return Toolkit.getDefaultToolkit().createDragGestureRecognizer(recognizer, this, c, actions, dgl);
    }

    public DragGestureRecognizer createDefaultDragGestureRecognizer(Component c, int actions, DragGestureListener dgl) {
        return this.createDragGestureRecognizer(MouseDragGestureRecognizer.class, c, actions, dgl);
    }

    public void addDragSourceListener(DragSourceListener l) {
        DnDEventMulticaster.add(this.dragSourceListener, l);
    }

    public void removeDragSourceListener(DragSourceListener l) {
        DnDEventMulticaster.remove(this.dragSourceListener, l);
    }

    public DragSourceListener[] getDragSourceListeners() {
        return (DragSourceListener[])this.getListeners(DragSourceListener.class);
    }

    public void addDragSourceMotionListener(DragSourceMotionListener l) {
        DnDEventMulticaster.add(this.dragSourceMotionListener, l);
    }

    public void removeDragSourceMotionListener(DragSourceMotionListener l) {
        DnDEventMulticaster.remove(this.dragSourceMotionListener, l);
    }

    public DragSourceMotionListener[] getDragSourceMotionListeners() {
        return (DragSourceMotionListener[])this.getListeners(DragSourceMotionListener.class);
    }

    public <T extends EventListener> T[] getListeners(Class<T> listenerType) {
        if (listenerType == DragSourceListener.class) {
            return DnDEventMulticaster.getListeners((EventListener)this.dragSourceListener, listenerType);
        }
        if (listenerType == DragSourceMotionListener.class) {
            return DnDEventMulticaster.getListeners((EventListener)this.dragSourceMotionListener, listenerType);
        }
        return new EventListener[0];
    }

    public static int getDragThreshold() throws NotImplementedException {
        return 8;
    }
}

