/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.util.regex;

import gnu.java.util.regex.CharIndexed;
import gnu.java.util.regex.REMatch;
import java.io.Serializable;

class CharIndexedCharSequence
implements CharIndexed,
Serializable {
    private CharSequence s;
    private int anchor;
    private int len;
    private REMatch lastMatch;
    private int rightmostTriedPosition = 0;

    CharIndexedCharSequence(CharSequence s, int index) {
        this.s = s;
        this.len = s.length();
        this.anchor = index;
    }

    public char charAt(int index) {
        int pos = this.anchor + index;
        return pos < this.len && pos >= 0 ? this.s.charAt(pos) : (char)'\uffff';
    }

    public boolean isValid() {
        return this.anchor < this.len;
    }

    public boolean move(int index) {
        return (this.anchor += index) < this.len;
    }

    public boolean move1(int index) {
        return (this.anchor += index) <= this.len;
    }

    public CharIndexed lookBehind(int index, int length) {
        if (length > this.anchor + index) {
            length = this.anchor + index;
        }
        return new CharIndexedCharSequence(this.s, this.anchor + index - length);
    }

    public int length() {
        return this.len - this.anchor;
    }

    public void setLastMatch(REMatch match) {
        this.lastMatch = (REMatch)match.clone();
        this.lastMatch.anchor = this.anchor;
    }

    public REMatch getLastMatch() {
        return this.lastMatch;
    }

    public void setHitEnd(REMatch match) {
        int pos = this.anchor + match.index;
        if (pos > this.rightmostTriedPosition) {
            this.rightmostTriedPosition = pos;
        }
    }

    public boolean hitEnd() {
        return this.rightmostTriedPosition >= this.len;
    }

    public int getAnchor() {
        return this.anchor;
    }

    public void setAnchor(int anchor) {
        this.anchor = anchor;
    }
}

