/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.x509.ext;

import gnu.java.security.OID;
import gnu.java.security.der.DERReader;
import gnu.java.security.der.DERValue;
import gnu.java.security.x509.Util;
import gnu.java.security.x509.ext.AuthorityKeyIdentifier;
import gnu.java.security.x509.ext.BasicConstraints;
import gnu.java.security.x509.ext.CRLNumber;
import gnu.java.security.x509.ext.CertificatePolicies;
import gnu.java.security.x509.ext.ExtendedKeyUsage;
import gnu.java.security.x509.ext.IssuerAlternativeNames;
import gnu.java.security.x509.ext.KeyUsage;
import gnu.java.security.x509.ext.NameConstraints;
import gnu.java.security.x509.ext.PolicyConstraint;
import gnu.java.security.x509.ext.PolicyMappings;
import gnu.java.security.x509.ext.PrivateKeyUsagePeriod;
import gnu.java.security.x509.ext.ReasonCode;
import gnu.java.security.x509.ext.SubjectAlternativeNames;
import gnu.java.security.x509.ext.SubjectKeyIdentifier;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Logger;

public class Extension {
    private static final Logger log = Logger.getLogger(Extension.class.getName());
    protected final OID oid;
    protected final boolean critical;
    protected boolean isSupported;
    protected final Value value;
    protected byte[] encoded;

    public Extension(byte[] encoded) throws IOException {
        this.encoded = (byte[])encoded.clone();
        DERReader der = new DERReader(encoded);
        DERValue val = der.read();
        if (!val.isConstructed()) {
            throw new IOException("malformed Extension");
        }
        val = der.read();
        if (val.getTag() != 6) {
            throw new IOException("expecting OBJECT IDENTIFIER");
        }
        this.oid = (OID)val.getValue();
        val = der.read();
        if (val.getTag() == 1) {
            this.critical = (Boolean)val.getValue();
            val = der.read();
        } else {
            this.critical = false;
        }
        if (val.getTag() != 4) {
            throw new IOException("expecting OCTET STRING");
        }
        byte[] encval = (byte[])val.getValue();
        this.isSupported = true;
        if (this.oid.equals(AuthorityKeyIdentifier.ID)) {
            this.value = new AuthorityKeyIdentifier(encval);
        } else if (this.oid.equals(SubjectKeyIdentifier.ID)) {
            this.value = new SubjectKeyIdentifier(encval);
        } else if (this.oid.equals(KeyUsage.ID)) {
            this.value = new KeyUsage(encval);
        } else if (this.oid.equals(PrivateKeyUsagePeriod.ID)) {
            this.value = new PrivateKeyUsagePeriod(encval);
        } else if (this.oid.equals(CertificatePolicies.ID)) {
            this.value = new CertificatePolicies(encval);
        } else if (this.oid.equals(PolicyConstraint.ID)) {
            this.value = new PolicyConstraint(encval);
        } else if (this.oid.equals(PolicyMappings.ID)) {
            this.value = new PolicyMappings(encval);
        } else if (this.oid.equals(SubjectAlternativeNames.ID)) {
            this.value = new SubjectAlternativeNames(encval);
        } else if (this.oid.equals(IssuerAlternativeNames.ID)) {
            this.value = new IssuerAlternativeNames(encval);
        } else if (this.oid.equals(BasicConstraints.ID)) {
            this.value = new BasicConstraints(encval);
        } else if (this.oid.equals(ExtendedKeyUsage.ID)) {
            this.value = new ExtendedKeyUsage(encval);
        } else if (this.oid.equals(CRLNumber.ID)) {
            this.value = new CRLNumber(encval);
        } else if (this.oid.equals(ReasonCode.ID)) {
            this.value = new ReasonCode(encval);
        } else if (this.oid.equals(NameConstraints.ID)) {
            this.value = new NameConstraints(encval);
        } else {
            this.value = new Value(encval);
            this.isSupported = false;
        }
    }

    public Extension(OID oid, Value value, boolean critical) {
        this.oid = oid;
        this.value = value;
        this.critical = critical;
        this.isSupported = true;
    }

    public OID getOid() {
        return this.oid;
    }

    public boolean isCritical() {
        return this.critical;
    }

    public boolean isSupported() {
        return this.isSupported;
    }

    public Value getValue() {
        return this.value;
    }

    public byte[] getEncoded() {
        if (this.encoded == null) {
            this.encode();
        }
        return (byte[])this.encoded.clone();
    }

    public String toString() {
        return String.valueOf(Extension.class.getName()) + " [ id=" + this.oid + " critical=" + this.critical + " value=" + this.value + " ]";
    }

    public DERValue getDerValue() {
        ArrayList<DERValue> ext = new ArrayList<DERValue>(3);
        ext.add(new DERValue(6, this.oid));
        ext.add(new DERValue(1, this.critical));
        ext.add(new DERValue(4, this.value.getEncoded()));
        return new DERValue(48, ext);
    }

    private void encode() {
        this.encoded = this.getDerValue().getEncoded();
    }

    public static class Value {
        protected byte[] encoded;

        public Value(byte[] encoded) {
            this.encoded = (byte[])encoded.clone();
        }

        protected Value() {
        }

        public byte[] getEncoded() {
            return this.encoded;
        }

        public int hashCode() {
            int result = 0;
            int i = 0;
            while (i < this.encoded.length) {
                result = result * 31 + this.encoded[i];
                ++i;
            }
            return result;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Value)) {
                return false;
            }
            return Arrays.equals(this.encoded, ((Value)o).encoded);
        }

        public String toString() {
            return Util.toHexString(this.encoded, ':');
        }
    }
}

