/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.net.loader;

import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.util.HashMap;

public class URLStreamHandlerCache {
    private HashMap<URLStreamHandlerFactory, HashMap<String, URLStreamHandler>> factoryCache = new HashMap(5);

    public synchronized void add(URLStreamHandlerFactory factory) {
        if (factory != null && this.factoryCache.get(factory) == null) {
            this.factoryCache.put(factory, new HashMap(5));
        }
    }

    public synchronized URLStreamHandler get(URLStreamHandlerFactory factory, String protocol) {
        if (factory == null) {
            return null;
        }
        HashMap<String, URLStreamHandler> cache = this.factoryCache.get(factory);
        URLStreamHandler handler = cache.get(protocol);
        if (handler == null) {
            handler = factory.createURLStreamHandler(protocol);
            cache.put(protocol, handler);
        }
        return handler;
    }
}

