/*
 * Decompiled with CFR 0.152.
 */
package sun.reflect.misc;

public class ReflectUtil {
    public static void checkPackageAccess(Class declaringClass) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            while (declaringClass.isArray()) {
                declaringClass = declaringClass.getComponentType();
            }
            String name = declaringClass.getName();
            int i = name.lastIndexOf(46);
            if (i != -1) {
                name = name.substring(0, i);
                sm.checkPackageAccess(name);
            }
        }
    }

    public static void ensureMemberAccess(Class caller, Class declarer, MustBeNull ignored, int modifiers) {
        if (caller == declarer) {
            return;
        }
        if ((modifiers & 1) != 0) {
            return;
        }
        if ((modifiers & 4) != 0 && declarer.isAssignableFrom(caller)) {
            return;
        }
        if ((modifiers & 2) == 0 && caller.getPackage() == declarer.getPackage()) {
            return;
        }
        throw new IllegalAccessError();
    }

    private static class MustBeNull {
        private MustBeNull() {
        }
    }
}

