/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

public class MenuSelectionManager {
    protected ChangeEvent changeEvent = new ChangeEvent(this);
    protected EventListenerList listenerList = new EventListenerList();
    private static final MenuSelectionManager manager = new MenuSelectionManager();
    private Vector selectedPath = new Vector();

    protected void fireStateChanged() {
        ChangeListener[] listeners = this.getChangeListeners();
        int i = 0;
        while (i < listeners.length) {
            listeners[i].stateChanged(this.changeEvent);
            ++i;
        }
    }

    public void addChangeListener(ChangeListener listener) {
        this.listenerList.add(ChangeListener.class, listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.listenerList.remove(ChangeListener.class, listener);
    }

    public ChangeListener[] getChangeListeners() {
        return (ChangeListener[])this.listenerList.getListeners(ChangeListener.class);
    }

    public void clearSelectedPath() {
        int i = this.selectedPath.size() - 1;
        while (i >= 0) {
            ((MenuElement)this.selectedPath.get(i)).menuSelectionChanged(false);
            --i;
        }
        this.selectedPath.clear();
        this.fireStateChanged();
    }

    public Component componentForPoint(Component source, Point sourcePoint) {
        Point sourcePointOnScreen = sourcePoint;
        if (source.isShowing()) {
            SwingUtilities.convertPointToScreen(sourcePointOnScreen, source);
        }
        Component resultComp = null;
        int i = 0;
        while (i < this.selectedPath.size()) {
            Component comp = (Component)this.selectedPath.get(i);
            Dimension size = comp.getSize();
            Point compPointOnScreen = comp.getLocationOnScreen();
            if (compPointOnScreen.x <= sourcePointOnScreen.x && sourcePointOnScreen.x < compPointOnScreen.x + size.width && compPointOnScreen.y <= sourcePointOnScreen.y && sourcePointOnScreen.y < compPointOnScreen.y + size.height) {
                Point p = sourcePointOnScreen;
                if (comp.isShowing()) {
                    SwingUtilities.convertPointFromScreen(p, comp);
                }
                resultComp = SwingUtilities.getDeepestComponentAt(comp, p.x, p.y);
                break;
            }
            ++i;
        }
        return resultComp;
    }

    public static MenuSelectionManager defaultManager() {
        return manager;
    }

    public MenuElement[] getSelectedPath() {
        MenuElement[] path = new MenuElement[this.selectedPath.size()];
        int i = 0;
        while (i < path.length) {
            path[i] = (MenuElement)this.selectedPath.get(i);
            ++i;
        }
        return path;
    }

    public boolean isComponentPartOfCurrentMenu(Component c) {
        boolean ret = false;
        int i = 0;
        while (i < this.selectedPath.size()) {
            MenuElement first = (MenuElement)this.selectedPath.get(i);
            if (SwingUtilities.isDescendingFrom(c, first.getComponent())) {
                ret = true;
                break;
            }
            MenuElement[] subElements = first.getSubElements();
            int j = 0;
            while (j < subElements.length) {
                MenuElement me = subElements[j];
                if (me != null && SwingUtilities.isDescendingFrom(c, me.getComponent())) {
                    ret = true;
                    break;
                }
                ++j;
            }
            ++i;
        }
        return ret;
    }

    public void processKeyEvent(KeyEvent e) {
        MenuElement[] path;
        MenuElement[] selection = this.selectedPath.toArray((S[])new MenuElement[this.selectedPath.size()]);
        if (selection.length == 0) {
            return;
        }
        int index = selection.length - 1;
        while (index >= 0) {
            MenuElement el = selection[index];
            MenuElement[] subEls = el.getSubElements();
            path = null;
            int subIndex = 0;
            while (subIndex < subEls.length) {
                MenuElement sub = subEls[subIndex];
                if (sub != null && sub.getComponent().isShowing() && sub.getComponent().isEnabled()) {
                    if (path == null) {
                        path = new MenuElement[index + 2];
                        System.arraycopy(selection, 0, path, 0, index + 1);
                    }
                    path[index + 1] = sub;
                    sub.processKeyEvent(e, path, this);
                    if (e.isConsumed()) break;
                }
                ++subIndex;
            }
            if (e.isConsumed()) break;
            --index;
        }
        if (!e.isConsumed()) {
            path = new MenuElement[]{selection[0]};
            path[0].processKeyEvent(e, path, this);
        }
    }

    public void processMouseEvent(MouseEvent event) {
        Component source = (Component)event.getSource();
        Component mouseOverMenuComp = event.getID() == 506 || event.getID() == 502 ? this.componentForPoint(source, event.getPoint()) : source;
        if (mouseOverMenuComp != null && mouseOverMenuComp instanceof MenuElement) {
            MenuElement[] path = this.getPath(mouseOverMenuComp);
            ((MenuElement)((Object)mouseOverMenuComp)).processMouseEvent(event, path, manager);
        } else if (event.getID() == 502) {
            this.clearSelectedPath();
        }
    }

    public void setSelectedPath(MenuElement[] path) {
        if (path == null) {
            this.clearSelectedPath();
            return;
        }
        int minSize = path.length;
        int currentSize = this.selectedPath.size();
        int firstDiff = 0;
        int i = 0;
        while (i < minSize) {
            if (i >= currentSize || (MenuElement)this.selectedPath.get(i) != path[i]) break;
            ++firstDiff;
            ++i;
        }
        i = currentSize - 1;
        while (i >= firstDiff) {
            MenuElement el = (MenuElement)this.selectedPath.get(i);
            this.selectedPath.remove(i);
            el.menuSelectionChanged(false);
            --i;
        }
        i = firstDiff;
        while (i < minSize) {
            if (path[i] != null) {
                this.selectedPath.add(path[i]);
                path[i].menuSelectionChanged(true);
            }
            ++i;
        }
        this.fireStateChanged();
    }

    private MenuElement[] getPath(Component c) {
        ArrayList<MenuElement> path = new ArrayList<MenuElement>();
        if (c instanceof JMenu) {
            path.add(((JMenu)c).getPopupMenu());
        }
        while (c instanceof MenuElement) {
            path.add(0, (MenuElement)((Object)c));
            c = c instanceof JPopupMenu ? ((JPopupMenu)c).getInvoker() : c.getParent();
        }
        MenuElement[] pathArray = new MenuElement[path.size()];
        path.toArray(pathArray);
        return pathArray;
    }
}

