/*
 * Decompiled with CFR 0.152.
 */
package javax.print.attribute;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import javax.print.attribute.Attribute;
import javax.print.attribute.AttributeSet;
import javax.print.attribute.AttributeSetUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HashAttributeSet
implements AttributeSet,
Serializable {
    private static final long serialVersionUID = 5311560590283707917L;
    private Class myInterface;
    private transient HashMap attributeMap = new HashMap();

    public HashAttributeSet() {
        this(Attribute.class);
    }

    public HashAttributeSet(Attribute attribute) {
        this(attribute, Attribute.class);
    }

    public HashAttributeSet(Attribute[] attributes) {
        this(attributes, Attribute.class);
    }

    public HashAttributeSet(AttributeSet attributes) {
        this(attributes, Attribute.class);
    }

    protected HashAttributeSet(Class<?> interfaceName) {
        if (interfaceName == null) {
            throw new NullPointerException("interfaceName may not be null");
        }
        this.myInterface = interfaceName;
    }

    protected HashAttributeSet(Attribute attribute, Class<?> interfaceName) {
        this(interfaceName);
        if (attribute == null) {
            throw new NullPointerException();
        }
        this.addInternal(attribute, interfaceName);
    }

    protected HashAttributeSet(Attribute[] attributes, Class<?> interfaceName) {
        this(interfaceName);
        if (attributes != null) {
            int index = 0;
            while (index < attributes.length) {
                this.addInternal(attributes[index], interfaceName);
                ++index;
            }
        }
    }

    protected HashAttributeSet(AttributeSet attributes, Class<?> interfaceName) {
        this(interfaceName);
        if (attributes != null) {
            this.addAllInternal(attributes, interfaceName);
        }
    }

    @Override
    public boolean add(Attribute attribute) {
        return this.addInternal(attribute, this.myInterface);
    }

    private boolean addInternal(Attribute attribute, Class interfaceName) {
        if (attribute == null) {
            throw new NullPointerException("attribute may not be null");
        }
        AttributeSetUtilities.verifyAttributeCategory(interfaceName, this.myInterface);
        Attribute old = this.attributeMap.put(attribute.getCategory(), AttributeSetUtilities.verifyAttributeValue(attribute, interfaceName));
        return !attribute.equals(old);
    }

    @Override
    public boolean addAll(AttributeSet attributes) {
        return this.addAllInternal(attributes, this.myInterface);
    }

    private boolean addAllInternal(AttributeSet attributes, Class interfaceName) {
        boolean modified = false;
        Attribute[] array = attributes.toArray();
        int index = 0;
        while (index < array.length) {
            if (this.addInternal(array[index], interfaceName)) {
                modified = true;
            }
            ++index;
        }
        return modified;
    }

    @Override
    public void clear() {
        this.attributeMap.clear();
    }

    @Override
    public boolean containsKey(Class<?> category) {
        return this.attributeMap.containsKey(category);
    }

    @Override
    public boolean containsValue(Attribute attribute) {
        return this.attributeMap.containsValue(attribute);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof HashAttributeSet)) {
            return false;
        }
        return this.attributeMap.equals(((HashAttributeSet)obj).attributeMap);
    }

    @Override
    public Attribute get(Class<?> category) {
        if (category == null) {
            throw new NullPointerException("category may not be null");
        }
        return (Attribute)this.attributeMap.get(category);
    }

    @Override
    public int hashCode() {
        int hashcode = 0;
        Iterator it = this.attributeMap.values().iterator();
        while (it.hasNext()) {
            hashcode += it.next().hashCode();
        }
        return hashcode;
    }

    @Override
    public boolean isEmpty() {
        return this.attributeMap.isEmpty();
    }

    @Override
    public boolean remove(Attribute attribute) {
        if (attribute == null) {
            return false;
        }
        return this.attributeMap.remove(attribute.getCategory()) != null;
    }

    @Override
    public boolean remove(Class<?> category) {
        if (category == null) {
            return false;
        }
        return this.attributeMap.remove(category) != null;
    }

    @Override
    public int size() {
        return this.attributeMap.size();
    }

    @Override
    public Attribute[] toArray() {
        int index = 0;
        Iterator it = this.attributeMap.values().iterator();
        Attribute[] array = new Attribute[this.size()];
        while (it.hasNext()) {
            array[index] = (Attribute)it.next();
            ++index;
        }
        return array;
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        this.myInterface = (Class)s.readObject();
        int size = s.readInt();
        this.attributeMap = new HashMap(size);
        int i = 0;
        while (i < size) {
            this.add((Attribute)s.readObject());
            ++i;
        }
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.writeObject(this.myInterface);
        s.writeInt(this.size());
        Iterator it = this.attributeMap.values().iterator();
        while (it.hasNext()) {
            s.writeObject(it.next());
        }
    }
}

