/*
 * Decompiled with CFR 0.152.
 */
package java.security.cert;

import gnu.java.lang.CPStringBuilder;
import gnu.java.security.Engine;
import java.lang.reflect.InvocationTargetException;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertPathBuilderResult;
import java.security.cert.CertPathBuilderSpi;
import java.security.cert.CertPathParameters;

public class CertPathBuilder {
    private static final String CERT_PATH_BUILDER = "CertPathBuilder";
    private CertPathBuilderSpi cpbSpi;
    private Provider provider;
    private String algorithm;

    protected CertPathBuilder(CertPathBuilderSpi cpbSpi, Provider provider, String algorithm) {
        this.cpbSpi = cpbSpi;
        this.provider = provider;
        this.algorithm = algorithm;
    }

    public static final String getDefaultType() {
        String type = Security.getProperty("certpathbuilder.type");
        if (type == null) {
            type = "PKIX";
        }
        return type;
    }

    public static CertPathBuilder getInstance(String algorithm) throws NoSuchAlgorithmException {
        Provider[] p = Security.getProviders();
        NoSuchAlgorithmException lastException = null;
        int i = 0;
        while (i < p.length) {
            try {
                return CertPathBuilder.getInstance(algorithm, p[i]);
            }
            catch (NoSuchAlgorithmException x) {
                lastException = x;
                ++i;
            }
        }
        if (lastException != null) {
            throw lastException;
        }
        throw new NoSuchAlgorithmException(algorithm);
    }

    public static CertPathBuilder getInstance(String algorithm, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (provider == null) {
            throw new IllegalArgumentException("provider MUST NOT be null");
        }
        Provider p = Security.getProvider(provider);
        if (p == null) {
            throw new NoSuchProviderException(provider);
        }
        return CertPathBuilder.getInstance(algorithm, p);
    }

    public static CertPathBuilder getInstance(String algorithm, Provider provider) throws NoSuchAlgorithmException {
        Throwable cause;
        CPStringBuilder sb = new CPStringBuilder("CertPathBuilder for algorithm [").append(algorithm).append("] from provider[").append(provider).append("] could not be created");
        try {
            Object spi = Engine.getInstance(CERT_PATH_BUILDER, algorithm, provider);
            return new CertPathBuilder((CertPathBuilderSpi)spi, provider, algorithm);
        }
        catch (InvocationTargetException x) {
            cause = x.getCause();
            if (cause instanceof NoSuchAlgorithmException) {
                throw (NoSuchAlgorithmException)cause;
            }
            if (cause == null) {
                cause = x;
            }
        }
        catch (ClassCastException x) {
            cause = x;
        }
        NoSuchAlgorithmException x = new NoSuchAlgorithmException(sb.toString());
        x.initCause(cause);
        throw x;
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final CertPathBuilderResult build(CertPathParameters params) throws CertPathBuilderException, InvalidAlgorithmParameterException {
        return this.cpbSpi.engineBuild(params);
    }
}

