/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.image;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.util.HashSet;
import java.util.Iterator;

public class AsyncImage
extends Image {
    private volatile Image realImage;
    HashSet<ImageObserver> observers = new HashSet();
    private volatile boolean complete = false;

    AsyncImage() {
    }

    public void flush() {
    }

    public Graphics getGraphics() {
        Image r = this.realImage;
        Graphics g = null;
        if (r != null) {
            g = r.getGraphics();
        }
        return g;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public int getHeight(ImageObserver observer) {
        this.addObserver(observer);
        int height = -1;
        this.waitForImage(observer);
        Image r = this.realImage;
        if (r != null) {
            height = r.getHeight(observer);
        }
        return height;
    }

    public Object getProperty(String name, ImageObserver observer) {
        this.addObserver(observer);
        Image r = this.realImage;
        Object prop = null;
        if (r != null) {
            prop = r.getProperty(name, observer);
        }
        return prop;
    }

    public ImageProducer getSource() {
        return new AsyncImageSource();
    }

    public int getWidth(ImageObserver observer) {
        this.addObserver(observer);
        int width = -1;
        this.waitForImage(observer);
        Image r = this.realImage;
        if (r != null) {
            width = r.getWidth(observer);
        }
        return width;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addObserver(ImageObserver obs) {
        if (obs != null) {
            AsyncImage asyncImage = this;
            synchronized (asyncImage) {
                HashSet<ImageObserver> observs = this.observers;
                if (observs != null) {
                    observs.add(obs);
                }
            }
        }
    }

    public boolean prepareImage(int w, int h, ImageObserver obs) {
        this.addObserver(obs);
        return this.realImage != null;
    }

    public int checkImage(int w, int h, ImageObserver obs) {
        this.addObserver(obs);
        int flags = 0;
        if (this.realImage != null) {
            flags = 39;
        }
        return flags;
    }

    public Image getRealImage() {
        return this.realImage;
    }

    public void setRealImage(Image im) {
        this.realImage = im;
        int status = 3;
        this.notifyObservers(status, 0, 0, im.getWidth(null), im.getHeight(null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyObservers(int status, int x, int y, int w, int h) {
        AsyncImage asyncImage = this;
        synchronized (asyncImage) {
            HashSet<ImageObserver> observs = this.observers;
            if (observs != null) {
                Iterator<ImageObserver> i = observs.iterator();
                while (i.hasNext()) {
                    ImageObserver obs = i.next();
                    boolean complete = obs.imageUpdate(this, status, x, y, this.realImage.getWidth(obs), this.realImage.getHeight(obs));
                    if (!complete) continue;
                    i.remove();
                }
            }
            if ((status & 0x20) != 0) {
                this.complete = true;
                this.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void waitForImage(ImageObserver observer) {
        if (this.complete) return;
        if (observer != null) return;
        AsyncImage asyncImage = this;
        synchronized (asyncImage) {
            while (true) {
                if (this.complete) {
                    return;
                }
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    private class AsyncImageSource
    implements ImageProducer {
        private ImageProducer realSource;

        private AsyncImageSource() {
        }

        public void addConsumer(ImageConsumer ic) {
            this.startProduction(ic);
        }

        public boolean isConsumer(ImageConsumer ic) {
            return false;
        }

        public void removeConsumer(ImageConsumer ic) {
        }

        public void requestTopDownLeftRightResend(ImageConsumer ic) {
            this.startProduction(ic);
        }

        public void startProduction(ImageConsumer ic) {
            ImageProducer ip = this.getRealSource();
            if (ip == null) {
                ic.setDimensions(1, 1);
                ic.imageComplete(2);
            } else {
                ip.startProduction(ic);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ImageProducer getRealSource() {
            AsyncImage asyncImage = AsyncImage.this;
            synchronized (asyncImage) {
                Image ri;
                ImageProducer source = this.realSource;
                if (source == null && (ri = AsyncImage.this.realImage) != null) {
                    this.realSource = source = ri.getSource();
                }
                return source;
            }
        }
    }
}

